% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{WH_1d_outer}
\alias{WH_1d_outer}
\title{Whittaker-Henderson Smoothing (Maximum Likelihood, optimize function)}
\usage{
WH_1d_outer(
  d,
  ec,
  y,
  wt,
  q = 2,
  p,
  criterion = "REML",
  lambda = 1000,
  reg = FALSE,
  verbose = FALSE,
  accu_crit = 1e-12,
  accu_dev = 1e-12
)
}
\arguments{
\item{d}{Vector of observed events}

\item{ec}{Vector of central exposure}

\item{y}{Vector of observations}

\item{wt}{Optional vector of weights}

\item{q}{Order of penalization. Polynoms of degrees q - 1 are considered
smooth and are therefore unpenalized}

\item{p}{The number of eigenvectors to keep}

\item{criterion}{Criterion used to choose the smoothing parameter. One of
"GCV" (default), "AIC" or "BIC".}

\item{lambda}{Initial smoothing parameter}

\item{reg}{Should the regression framework be used ? Boolean. If \code{TRUE}, will
stop after the first iteration.}

\item{verbose}{Should information about the optimization progress be
displayed}

\item{accu_crit}{Tolerance for the convergence of the outer optimization
procedure}

\item{accu_dev}{Tolerance for the convergence of the optimization procedure}
}
\value{
An object of class \code{"WH_1d"} i.e. a list containing model fit,
variance, residuals and degrees of freedom as well as diagnosis to asses
the quality of the fit.
}
\description{
Whittaker-Henderson Smoothing (Maximum Likelihood, optimize function)
}
\keyword{internal}
