% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.WCE.R
\name{coef.WCE}
\alias{coef.WCE}
\title{Obtain estimated coefficients from \code{WCE} object}
\usage{
\method{coef}{WCE}(object, ...)
}
\arguments{
\item{object}{A \code{WCE} object.}

\item{\dots}{Optional; other parameters to be passed through to \code{coef}.}
}
\value{
WCEest Matrix of estimated coefficients of the artificial D variables.

covariates Matrix of estimated coefficients of the covariates (optional).
}
\description{
This function extracts the estimated coefficients from a WCE object.
}
\details{
The function returns a list with one element if the WCE object was fitted without covariates and two if the WCE object was fitted with covariates. The first element is a matrix of estimated coefficients for the artificial D variables (see Sylvestre and Abrahamowicz, 2009). Each row of the matrix corresponds to a model with the number of knots specified in \code{WCE}. The second element of the list is a matrix of estimated covariate coefficients. Similarly, each row of the matrix corresponds to a model with the number of knots specified in \code{WCE}.
}
\examples{
wce <- WCE(data=drugdata, analysis="Cox", nknots=1, cutoff = 90, constrained = "R",
id = "Id", event = "Event", start = "Start", stop = "Stop", expos = "dose",
covariates = c("age", "sex"))
coef(wce)

}
\references{
Sylvestre, M. P., & Abrahamowicz, M. (2009). Flexible modeling of the cumulative effects of time-dependent exposures on the hazard. Statistics in medicine, 28(27), 3437-3453.
}
\seealso{
\code{\link[WCE]{WCE}}
}
