% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_AR.R
\name{data.gen.ar1}
\alias{data.gen.ar1}
\title{Generate predictor and response data from AR1 model.}
\usage{
data.gen.ar1(nobs, ndim = 9)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{ndim}{The number of potential predictors (default is 9).}
}
\value{
A list of 2 elements: a vector of response (x), and a matrix of potential predictors (dp) with each column containing one potential predictor.
}
\description{
Generate predictor and response data from AR1 model.
}
\examples{
# AR1 model from paper with 9 dummy variables
data.ar1 <- data.gen.ar1(500)
plot.ts(cbind(data.ar1$x, data.ar1$dp))
}
