% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simon_pr.R
\name{Simon_pr}
\alias{Simon_pr}
\title{Probabilities of Simon's Two-Stage Design}
\usage{
Simon_pr(prob, n1, n, r1, r)
}
\arguments{
\item{prob}{\link[base]{numeric} vector, true response rate(s)}

\item{n1, n}{\link[base]{integer} scalars, Stage 1 sample size \eqn{n_1} and total sample size \eqn{n}}

\item{r1, r}{\link[base]{integer} scalars, number of positive response
in Stage 1 \eqn{r_1} and overall \eqn{r} required \strong{exclusive}.
In other words, passing Stage 1 means observing \eqn{>r_1} positive response.}
}
\value{
\link{Simon_pr} returns \linkS4class{Simon_pr} object.
}
\description{
Probability of frail
(i.e., early termination), fail (to reject the null) and success (to reject the null)
of a Simon's Two-Stage Design, at given true response rate(s).
}
\details{
Parameters nomenclature of \code{n1}, \code{n}, \code{r1} and \code{r} follows that of
PASS and \link[clinfun]{ph2simon}.
}
\examples{
Simon_pr(n1 = 15L, r1 = 3L, n = 24L, r = 7L, prob = c(.2, .3))

}
\references{
\doi{10.1016/0197-2456(89)90015-9}
}
