% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pw_root.R
\name{pw_root}
\alias{pw_root}
\title{Equation for which root must be determined.}
\usage{
pw_root(t, breakpoints, rates, uu)
}
\arguments{
\item{t}{Vector of durations to be considered in determining root.}

\item{breakpoints}{Breakpoints}

\item{rates}{Piecewise-constant rates}

\item{uu}{Random draw from standard uniform distribution.}
}
\value{
Vector of differences between cumulative hazard and -log(uu) for
different values of t.
}
\description{
Equation: cumulative hazard functionn + log(uu) = 0
}
\details{
The function is called by function uniroot (base R), which is called by
r.pw_exp
}
\examples{
breakpoints <- c(0, 10, 20, 30, 60)
rates <- c(0.01,0.02,0.04,0.15)
z <- pw_root (t= c(10,18.3,23.6,54.7),breakpoints,rates,uu=0.43)

}
\seealso{
Functions H_pw and r.pw_exp
}
\author{
Frans Willekens
}
