% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopChiPlot.R
\name{BiCopChiPlot}
\alias{BiCopChiPlot}
\title{Chi-plot for Bivariate Copula Data}
\usage{
BiCopChiPlot(u1, u2, PLOT = TRUE, mode = "NULL", ...)
}
\arguments{
\item{u1, u2}{Data vectors of equal length with values in [0,1].}

\item{PLOT}{Logical; whether the results are plotted. If \code{PLOT =
FALSE}, the values \code{lambda}, \code{chi} and \code{control.bounds} are
returned (see below; default: \code{PLOT = TRUE}).}

\item{mode}{Character; whether a general, lower or upper chi-plot is
calculated.  Possible values are \code{mode = "NULL"}, \code{"upper"} and
\code{"lower"}. \cr \code{"NULL"} = general chi-plot (default)\cr
\code{"upper"} = upper chi-plot\cr \code{"lower"} = lower chi-plot}

\item{...}{Additional plot arguments.}
}
\value{
\item{lambda}{Lambda-statistics (x-axis).} \item{chi}{Chi-statistics
(y-axis).} \item{control.bounds}{A 2-dimensional vector of bounds
\eqn{((1.54/\sqrt{n},-1.54/\sqrt{n})}, where \eqn{n} is the length of
\code{u1} and where the chosen values correspond to an approximate
significance level of 10\%.}
}
\description{
This function creates a chi-plot of given bivariate copula data.
}
\details{
For observations \eqn{u_{i,j},\ i=1,...,N,\ j=1,2,}{u_{i,j}, i=1,...,N,
j=1,2,} the chi-plot is based on the following two quantities: the
chi-statistics
\deqn{\chi_i = \frac{\hat{F}_{1,2}(u_{i,1},u_{i,2})
- \hat{F}_{1}(u_{i,1})\hat{F}_{2}(u_{i,2})}{
\sqrt{\hat{F}_{1}(u_{i,1})(1-\hat{F}_{1}(u_{i,1}))
\hat{F}_{2}(u_{i,2})(1-\hat{F}_{2}(u_{i,2}))}}, }{
\chi_i = F_{1,2}(u_{i,1},u_{i,2}) - F_{1}(u_{i,1})F_{2}(u_{i,2})
/ (F_{1}(u_{i,1}) (1-F_{1}(u_{i,1}))F_{2}(u_{i,2})
(1-F_{2}(u_{i,2}))^0.5, }
and the lambda-statistics
\deqn{\lambda_i = 4 sgn\left( \tilde{F}_{1}(u_{i,1}),\tilde{F}_{2}(u_{i,2}) \right)
\cdot \max\left( \tilde{F}_{1}(u_{i,1})^2,\tilde{F}_{2}(u_{i,2})^2 \right), }{
\lambda_i = 4 sgn( tildeF_{1}(u_{i,1}),tildeF_{U_2}(u_{i,2}) )
* max( tildeF_{U_1}(u_{i,1})^2,tildeF_{U_2}(u_{i,2})^2 ),
}
where \eqn{\hat{F}_{1}}{F_{1}}, \eqn{\hat{F}_{2}}{F_{2}} and
\eqn{\hat{F}_{1,2}}{F_{1,2}} are the empirical distribution functions
of the uniform random variables \eqn{U_1} and \eqn{U_2} and of
\eqn{(U_1,U_2)}, respectively. Further,
\eqn{\tilde{F}_{1}=\hat{F}_{1}-0.5}{tildeF_{1}=F_{1}-0.5} and
\eqn{\tilde{F}_{2}=\hat{F}_{2}-0.5}{tildeF_{2}=F_{2}-0.5}.

These quantities only depend on the ranks of the data and are scaled to the
interval \eqn{[0,1]}. \eqn{\lambda_i} measures a distance of a data point
\eqn{\left(u_{i,1},u_{i,2}\right)}{(u_{i,1},u_{i,2})} to the center of the
bivariate data set, while \eqn{\chi_i} corresponds to a correlation
coefficient between dichotomized values of \eqn{U_1} and \eqn{U_2}. Under
independence it holds that \eqn{\chi_i \sim
\mathcal{N}(0,\frac{1}{N})}{\chi_i~N(0,1/N)} and \eqn{\lambda_i \sim
\mathcal{U}[-1,1]}{\lambda_i~U[0,1]} asymptotically, i.e., values of
\eqn{\chi_i} close to zero indicate independence---corresponding to
\eqn{F_{1, 2}=F_{1}F_{2}}.

When plotting these quantities, the pairs of \eqn{\left(\lambda_i, \chi_i
\right)}{(\lambda_i,\chi_i)} will tend to be located above zero for
positively dependent margins and vice versa for negatively dependent
margins. Control bounds around zero indicate whether there is significant
dependence present.

If \code{mode = "lower"} or \code{"upper"}, the above quantities are
calculated only for those \eqn{u_{i,1}}'s and \eqn{u_{i,2}}'s which are
smaller/larger than the respective means of
\code{u1}\eqn{=(u_{1,1},...,u_{N,1})} and
\code{u2}\eqn{=(u_{1,2},...,u_{N,2})}.
}
\examples{

## chi-plots for bivariate Gaussian copula data

# simulate copula data
fam <- 1
tau <- 0.5
par <- BiCopTau2Par(fam, tau)
cop <- BiCop(fam, par)
set.seed(123)
dat <- BiCopSim(500, cop)

# create chi-plots
op <- par(mfrow = c(1, 3))
BiCopChiPlot(dat[,1], dat[,2], xlim = c(-1,1), ylim = c(-1,1),
             main="General chi-plot")
BiCopChiPlot(dat[,1], dat[,2], mode = "lower", xlim = c(-1,1),
             ylim = c(-1,1), main = "Lower chi-plot")
BiCopChiPlot(dat[,1], dat[,2], mode = "upper", xlim = c(-1,1),
             ylim = c(-1,1), main = "Upper chi-plot")
par(op)

}
\references{
Abberger, K. (2004). A simple graphical method to explore
tail-dependence in stock-return pairs. Discussion Paper, University of
Konstanz, Germany.

Genest, C. and A. C. Favre (2007). Everything you always wanted to know
about copula modeling but were afraid to ask. Journal of Hydrologic
Engineering, 12 (4), 347-368.
}
\seealso{
\code{\link{BiCopMetaContour}}, \code{\link{BiCopKPlot}},
\code{\link{BiCopLambda}}
}
\author{
Natalia Belgorodski, Ulf Schepsmeier
}
