% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleVLTransferEntropy.R
\name{multipleVLTransferEntropy}
\alias{multipleVLTransferEntropy}
\title{multipleVLTransferEntropy}
\usage{
multipleVLTransferEntropy(
  TS,
  maxLag,
  nboot = 0,
  lx = 1,
  ly = 1,
  VLflag = TRUE,
  autoLagflag = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{TS}{is a numerical time series of effect where \code{TS[t,k]} is an element at time \code{t} of \code{k}th time series.}

\item{maxLag}{is a maximum possible time delay. The default is 0.2*length(Y).}

\item{nboot}{is a number of times of bootstrapping for RTransferEntropy::transfer_entropy() function.}

\item{lx, ly}{are lag parameters of RTransferEntropy::transfer_entropy().}

\item{VLflag}{is a flag of Granger causality choice: either \code{VLflag=TRUE} for VL-Granger or \code{VLflag=FALSE} for Granger causality.}

\item{autoLagflag}{is a flag for enabling the automatic lag inference function. The default is true.
If it is set to be true, then maxLag is set automatically using cross-correlation.
Otherwise, if it is set to be false, then the function takes the maxLag value to infer Granger causality.}

\item{alpha}{is a significant-level threshold for TE bootstrapping by Dimpfl and Peter (2013).}
}
\value{
This function returns of a list of an adjacency matrix of causality where \code{adjMat[i,j]} is true if \code{TS[,i]} causes \code{TS[,j]}.
}
\description{
multipleVLTransferEntropy is a function that infers Variable-lag Transfer Entropy of all pairwises of \code{m} time series \code{TS[,1],...TS[,m]}.
}
\examples{
## Generate simulation data
#out1<-SimpleSimulationVLtimeseries()
#TS<-cbind(out1$X,out1$Y)
## Run the function
#out2<-multipleVLTransferEntropy(TS,maxLag=1)


}
