% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_auc.R
\name{simple_auc}
\alias{simple_auc}
\title{Primitive non-parametric function for calculating AUC or C-statistic for two
comparable samples with ordinal data.}
\usage{
simple_auc(norm, abnorm)
}
\arguments{
\item{norm}{Ordinal data of the norm group (controls).}

\item{abnorm}{Ordinal data of the abnorm group (patients).}
}
\value{
The statistic AUC (Area under the Receiver Operating Characteristics
Curve), also known as the C-statistic or Concordance statistic.
}
\description{
Primitive non-parametric function for calculating AUC or C-statistic for two
comparable samples with ordinal data.
}
\details{
This function does not check anything. Argument \code{norm} and
\code{abnorm} must have the correct ordinal data. When \code{mean(norm) >
  mean(abnorm)} it is assumed that lower sores indicate deviation from the
norm, and otherwise that higher scores indicate deviation of the norm.
This function can handle very large files.
}
\examples{
norm = round(rnorm(100, 3, 1))
abnorm= round(rnorm(80, 5, 2))
simple_auc(norm, abnorm)
}
