% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-uncertaintyError.R
\name{uncertaintyError}
\alias{uncertaintyError}
\title{Creates S4 object class UncertainPoints}
\usage{
uncertaintyError(input, T = NULL, grid = FALSE, distances = NULL,
  dim = NULL, data = NULL, given = NULL)
}
\arguments{
\item{input}{Input data. S4 class of \code{Points}}

\item{T}{optional vector of time coordinates, T must always be an equidistant vector. Instead of T=seq(from=From, by=By, len=Len) one may also write T=c(From, By, Len).}

\item{grid}{Logical; RandomFields can find itself the correct value in nearly all cases, so that usually grid need not be given.}

\item{distances}{Another alternative to pass the (relative) coordinates.}

\item{dim}{Only used if distances are given.}

\item{data}{For conditional simulation and random imputing only. If data is missing, unconditional simulation is performed.}

\item{given}{Optional, matrix or list. If given matrix then the coordinates can be given separately, namely by given where, in each row, a single location is given.}
}
\value{
Returns an object of class \code{UncertainPoints}.
}
\description{
Builds an uncertainty model over the input data based on the spatially 
correlated errors. Input data must be type of S4 class \code{Points}. 
Output object is type of S4 class \code{UncertainPoints}.
}
\details{
For the calculations of spatially correlated errors was used package RandomFields.
}
\seealso{
\code{\link[UncerIn2]{Points-class}}, \code{\link[UncerIn2]{UncertainPoints-class}}, \code{\link[RandomFields]{RFsimulate}}, \code{\link[UncerIn2]{uncertaintyInterpolation2-package}}
}

