% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{AnnualStat}
\alias{AnnualStat}
\title{Annual statistics extraction}
\usage{
AnnualStat(
  x,
  Stat = max,
  Truncate = TRUE,
  Mon = 10,
  Hr = 9,
  Sliding = FALSE,
  N = 24,
  ...
)
}
\arguments{
\item{x}{a data.frame with dates (or POSIXct) in the first column and variable in the second}

\item{Stat}{A user chosen function to extract statistics, for example mean. The default it max. User supplied functions could also be used.}

\item{Truncate}{Logical argument with a default of TRUE. If TRUE, then x is truncated to be within the first and last occurrence of the chosen month and time. If FALSE tuncation is not done and results from partial years will be included.}

\item{Mon}{Choice of month as a numeric, from 1 to 12. The default is 10 which means the year starts October 1st.}

\item{Hr}{Choice of hour to start the year (numeric from 0 to 23). The default is 9.}

\item{Sliding}{Logical argument with a default of FALSE. This can be applied if you want the statistic over a sliding period. For example, deriving maximum annual rainfall totals over a 24 hour period, rather than the maximum daily totals. The number of periods (timesteps) is chosen with the N argument. If for example you want the annual maximum sum of rainfall over a 24 hour period, and you have 15minute data, the Stat input would be sum, and N would be 96 (because there are 96 15 minute periods in 24 hours).}

\item{N}{Number of timesteps to slide over - used in conjunction with Sliding. The default is 24, make sure to adjust this depending on the duration of interest and the sampling rate of the input data.}

\item{...}{further arguments for the stat function. Such as na.rm = TRUE.}
}
\value{
a data.frame with columns; DateTime and Result. By default Result is the annual maximum sample, but will be any statistic used as the Stat argument.
}
\description{
Extracts annual statistics (default maximums) from a data.frame which has dates (or POSIXct) in the first column and variable in the second.
}
\details{
The statistics are extracted based on the UK hydrological year by default (start month = 10). Month can be changed using the Mon argument. A year is from Mon-Hr to Mon-(Hr-1). For example, the 2018 hydrological year with Hr = 9 would be from 2018-10-01 09:00:00 to 2019-10-01 08:00:00. If Hr = 0, then it would be from 2018-10-01 00:00:00 to 2019-09-30 23:00:00. Data before the first occurrence of the 'start month' and after and including the last occurrence of the 'start month' is not included in the calculation of the statistic.
}
\examples{
#Extract the Thames AMAX daily mean flow and display the first six rows
ThamesAM <- AnnualStat(ThamesPQ[,c(1,3)])
head(ThamesAM)
#Extract the annual rainfall totals.
ThamesAnnualP <- AnnualStat(ThamesPQ[,1:2], Stat = sum)
#Extract maximum five day rainfall totals from the Thames rain
ThamesP5DayAM <- AnnualStat(ThamesPQ[,1:2], Stat = sum, Sliding = TRUE, N = 5)
}
\author{
Anthony Hammond
}
