% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{TrendTest}
\alias{TrendTest}
\title{Trend hypothesis test}
\usage{
TrendTest(x, method = "kendall")
}
\arguments{
\item{x}{a numeric vector or a data.frame with dates in the first column and chronologically ordered variable in the second.}

\item{method}{a choice of test method. Choices are "pearson", "spearman", and "kendall"}
}
\value{
A data.frame with columns and associated values: P_value, correlation coefficient, and method specific statistic.
}
\description{
A hypothesis test for the correlation between the variable of interest and time
}
\details{
The test can be performed on a numeric vector, or a data.frame with dates in the first column and the associated variable of interest in the second. A choice can be made between a Pearson's, Spearman's Rho or Kendall's tau test. The Spearman and Kendall are based on ranks and will therefore have the same results whether dates are included or not. The default is kendall.
}
\examples{
#Get AMAX sample and apply a trend test with the default kendall test.
AM.27083 <- GetAM(27083)
TrendTest(AM.27083)
#Apply the test with the pearson method with dates included and not
TrendTest(AM.27083, method = "pearson")
TrendTest(AM.27083$Flow, method = "pearson")
}
\author{
Anthony Hammond
}
