% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_2rm.R
\name{predict.TwoRegression}
\alias{predict.TwoRegression}
\title{Predict metabolic equivalents from a TwoRegression object}
\usage{
\method{predict}{TwoRegression}(
  object,
  newdata,
  min_mets = object$sed_METs,
  max_mets = 20,
  warn_high_low = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{the TwoRegression object}

\item{newdata}{the data on which to predict metabolic equivalents (METs)}

\item{min_mets}{the minimum allowable value for MET predictions. Defaults to
the value stored in \code{object$sed_METs}}

\item{max_mets}{the maximum allowable value for MET predictions. There is no
value embedded in \code{object}. The default is 20}

\item{warn_high_low}{logical. Issue warnings about values less than
\code{min_mets} or greater than \code{max_mets}?}

\item{verbose}{logical. Print processing updates?}

\item{...}{further arguments passed to or from other methods}
}
\value{
A two-column data frame giving the activity classification
  (sedentary, walk/run, or intermittent activity) and the corresponding
  metabolic equivalent prediction
}
\description{
Predict metabolic equivalents from a TwoRegression object
}
\examples{
data(all_data, package = "TwoRegression")
all_data$PID <-
  rep(
    c("Test1", "Test2"),
    each = ceiling(nrow(all_data) / 2))[seq(nrow(all_data))]

train_data <- all_data[all_data$PID != "Test2", ]
test_data <- all_data[all_data$PID == "Test2", ]

fake_sed <- c("Lying", "Sitting")
fake_lpa <- c("Sweeping", "Dusting")
fake_cwr <- c("Walking", "Running")
fake_ila <- c("Tennis", "Basketball")

fake_activities <- c(fake_sed, fake_lpa, fake_cwr, fake_ila)

train_data$Activity <-
  sample(fake_activities, nrow(train_data), TRUE)

train_data$fake_METs <-
  ifelse(train_data$Activity \%in\% c(fake_sed, fake_lpa),
    runif(nrow(train_data), 1, 2),
    runif(nrow(train_data), 2.5, 8)
  )

ex_2rm <- fit_2rm(
  data = train_data,
  activity_var = "Activity",
  sed_cp_activities = c(fake_sed, fake_lpa),
  sed_activities = fake_sed,
  sed_cp_var = "ENMO",
  sed_METs = 1.25,
  walkrun_activities = fake_cwr,
  walkrun_cp_var = "ENMO_CV10s",
  met_var = "fake_METs",
  walkrun_formula = "fake_METs ~ ENMO",
  intermittent_formula = "fake_METs ~ ENMO + I(ENMO^2) + I(ENMO^3)"
)

predict(ex_2rm, test_data)

}
