% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Start_Trading.R
\name{Start_Trading}
\alias{Start_Trading}
\title{Start_Trading}
\usage{
Start_Trading(
  consumer_key,
  consumer_secret,
  access_token,
  access_secret,
  path_decision,
  ntweets,
  terms_list,
  time_tweet,
  time_zone,
  positive_dictionary,
  negative_dictionary,
  stock_symbol,
  path_twits,
  Operation_Hours1,
  Operation_Hours2,
  Operation_Hours3,
  start_time1,
  start_time2,
  start_time3,
  end_time1,
  end_time2,
  end_time3,
  Day_Trade,
  nap_time_error,
  initial_time,
  final_time,
  freq_trade,
  w_twitter,
  w_stocktwits,
  Sentiment_Index_Threshold,
  Use_Delta_Sentiment,
  Signal_File_Name
)
}
\arguments{
\item{consumer_key}{Api Twitter Consumer Key}

\item{consumer_secret}{Api Twitter Consumer Secret}

\item{access_token}{Api Twitter access token}

\item{access_secret}{Api Twitter access secret}

\item{path_decision}{The path where the txt file with the decision will be saved. Generally it is saved in the 'Common' file at Metaquotes folder(see vignette for instructions).}

\item{ntweets}{see get_sentiment_tweets.}

\item{terms_list}{see get_sentiment_tweets.}

\item{time_tweet}{see get_sentiment_tweets.}

\item{time_zone}{see get_sentiment_tweets.}

\item{positive_dictionary}{see get_sentiment_tweets.}

\item{negative_dictionary}{see get_sentiment_tweets.}

\item{stock_symbol}{see get_sentiment_Stocktwits.}

\item{path_twits}{see get_sentiment_Stocktwits.}

\item{Operation_Hours1}{The operation hours 1 for day trade. TRUE or FALSE.}

\item{Operation_Hours2}{The operation hours 2 for day trade. TRUE or FALSE.}

\item{Operation_Hours3}{The operation hours 3 for day trade. TRUE or FALSE.}

\item{start_time1}{The start time 1 for day trade.}

\item{start_time2}{The start time 2 for day trade.}

\item{start_time3}{The start time 3 for day trade.}

\item{end_time1}{The end time 1 for day trade.}

\item{end_time2}{The end time 2 for day trade.}

\item{end_time3}{The end time 3 for day trade.}

\item{Day_Trade}{True for Day Trade. False for Swing Trade.}

\item{nap_time_error}{The time that the EA should take a nap in case of error.}

\item{initial_time}{The start of operation.}

\item{final_time}{The time which the position in day trade mode must be closed.}

\item{freq_trade}{The time in minutes the EA must recompute the sentiment index and take a decision.}

\item{w_twitter}{The weight of the twitter sentiment index.}

\item{w_stocktwits}{The weight of the stocktwits sentiment index.}

\item{Sentiment_Index_Threshold}{see trade_decision function.}

\item{Use_Delta_Sentiment}{see trade_decision function}

\item{Signal_File_Name}{The Signal File Name.}
}
\value{
The functions just activate the algorithm.
}
\description{
This function starts the Algorithm and sends the ordes to txt file that will be read for the Expert Advisor in the Metatrader 5.
}
\examples{
\dontrun{
#Not run:
Signal_File_Name <- 'Signal.txt'
ntweets <- 5000
time_tweet <- 6
terms_list <- c("IBOVESPA OR bovespa OR ibov OR petroleo OR $SPX OR $SPY OR $EWZ")
time_zone <- "Brazil/East"
positive_dictionary <- my_dictionary[['positive_terms']]
negative_dictionary <- my_dictionary[['negative_terms']]

path_twits <- 'your path'
stock_symbol <- c("EWZ", "SPX", "SPY", "USO")
time_zone <- "Brazil/East"

consumer_key <- "your consumer_key"
consumer_secret <- "your consumer_secret"
access_token <- "your access token"
access_secret <- " your access secret "
nap_time_error <- 7.7
path_decision <- 'metatrader txt file path'
path_twits <- 'your path'
initial_time <- 9
final_time <- 17
freq_trade <- 10
Day_Trade <- TRUE
Operation_Hours1 <- TRUE
start_time1 <- 9
end_time1 <- 17
w_twitter <- 0.9
w_stocktwits <- 0.1
Sentiment_Index_Threshold <- 0.5


Start_Trading(consumer_key = consumer_key,
             consumer_secret = consumer_secret,
             access_token = access_token,
             access_secret = access_secret,
             path_decision = path_decision,
             ntweets = ntweets,
             terms_list = terms_list,
             time_tweet = time_tweet,
             time_zone = time_zone,
             positive_dictionary = positive_dictionary,
             negative_dictionary = negative_dictionary,
             stock_symbol = stock_symbol,
             path_twits = path_twits,
             Operation_Hours1 = TRUE,
             Operation_Hours2 = FALSE,
             Operation_Hours3 = FALSE,
             start_time1 = start_time1,
             start_time2 = start_time1,
             start_time3 = start_time1,
             end_time1 = end_time1,
             end_time2 = end_time1,
             end_time3 = end_time1,
             Day_Trade = TRUE,
             nap_time_error = nap_time_error,
             initial_time = initial_time,
             final_time = final_time,
             freq_trade = freq_trade,
             w_twitter = w_twitter,
             w_stocktwits = w_stocktwits,
             Sentiment_Index_Threshold = Sentiment_Index_Threshold,
             Use_Delta_Sentiment = TRUE,
             Signal_File_Name = Signal_File_Name)
}


}
