context("Truncation")

n <- 100
set.seed(233)
beta_all <- rtruncbeta(n, shape1 = 3, shape2 = 4)
set.seed(233)
beta_trunc <- rtruncbeta(n, shape1 = 3, shape2 = 4, a = .2, b = .6)
set.seed(233)
binom_all <- rtruncbinom(n, size = 8, prob = .18)
set.seed(233)
binom_trunc <- rtruncbinom(n, size = 8, prob = .18, a = 1, b = 3)
set.seed(233)
chisq_all <- rtruncchisq(n, df = 375)
set.seed(233)
chisq_trunc <- rtruncchisq(n, df = 375, a = 360, b = 390)
set.seed(233)
contb_all <- rtrunccontbern(n, lambda = .317)
set.seed(233)
contb_trunc <- rtrunccontbern(n, lambda = .317, a = .4, b = .7)
set.seed(233)
exp_all <- rtruncexp(n, rate = .37)
set.seed(233)
exp_trunc <- rtruncexp(n, rate = .37, a = 4, b = 7)
set.seed(233)
gamma1_all <- rtruncgamma(n, shape = 5, rate = 3)
set.seed(233)
gamma1_trunc <- rtruncgamma(n, shape = 5, rate = 3, a = 1.5, b = 2)
set.seed(233)
gamma2_all <- rtruncgamma(n, shape = 5, scale = 3)
set.seed(233)
gamma2_trunc <- rtruncgamma(n, shape = 5, scale = 3, a = 7, b = 9)
set.seed(233)
igamma1_all <- rtruncinvgamma(n, shape = 5, rate = 3)
set.seed(233)
igamma1_trunc <- rtruncinvgamma(n, shape = 5, rate = 3, a = .5, b = .6)
set.seed(233)
igamma2_all <- rtruncinvgamma(n, shape = 5, scale = 3)
set.seed(233)
igamma2_trunc <- rtruncinvgamma(n, shape = 5, scale = 3, a = .1, b = .2)
set.seed(233)
igauss_all <- rtruncinvgauss(n, m = 31, s = 74)
set.seed(233)
igauss_trunc <- rtruncinvgauss(n, m = 31, s = 74, a = 0, b = 1)
set.seed(233)
lnorm_all <- rtrunclnorm(n, meanlog = 0, sdlog = .7)
set.seed(233)
lnorm_trunc <- rtrunclnorm(n, meanlog = 0, sdlog = .7, a = 3, b = 4)
set.seed(233)
nbinom1_all <- rtruncnbinom(n, size = 63, prob =.62)
set.seed(233)
nbinom1_trunc <- rtruncnbinom(n, size = 63, prob = .62, a=30, b=40)
set.seed(233)
nbinom2_all <- rtruncnbinom(n, size = 63, mu = 6)
set.seed(233)
nbinom2_trunc <- rtruncnbinom(n, size = 63, mu = 6, a = 4, b = 6)
set.seed(233)
norm_all <- rtruncnorm(n, mean = 81, sd = 49)
set.seed(233)
norm_trunc <- rtruncnorm(n, mean = 81, sd = 49, a = 50, b = 99)
set.seed(233)
pois_all <- rtruncpois(n, lambda = 95)
set.seed(233)
pois_trunc <- rtruncpois(n, lambda = 95, a = 100, b = 101)
beta_diff <- setdiff(beta_all, beta_trunc)
binom_diff <- setdiff(binom_all, binom_trunc)
chisq_diff <- setdiff(chisq_all, chisq_trunc)
contb_diff <- setdiff(contb_all, contb_trunc)
exp_diff <- setdiff(exp_all, exp_trunc)
gamma1_diff <- setdiff(gamma1_all, gamma1_trunc)
gamma2_diff <- setdiff(gamma2_all, gamma2_trunc)
igamma1_diff <- setdiff(igamma1_all, igamma1_trunc)
igamma2_diff <- setdiff(igamma2_all, igamma2_trunc)
igauss_diff <- setdiff(igauss_all, igauss_trunc)
lnorm_diff <- setdiff(lnorm_all, lnorm_trunc)
nbinom1_diff <- setdiff(nbinom1_all, nbinom1_trunc)
nbinom2_diff <- setdiff(nbinom2_all, nbinom2_trunc)
norm_diff <- setdiff(norm_all, norm_trunc)
pois_diff <- setdiff(pois_all, pois_trunc)
test_that("Truncation limits are working as expected", {
  expect_setequal(beta_trunc[beta_trunc >= .2 & beta_trunc <= .6], beta_trunc)
  expect_setequal(binom_trunc[binom_trunc >= 1 & binom_trunc <= 3], binom_trunc)
  expect_setequal(chisq_trunc[chisq_trunc >= 360 & chisq_trunc <= 390], chisq_trunc)
  expect_setequal(contb_trunc[contb_trunc >= .4 & contb_trunc <= .7], contb_trunc)
  expect_setequal(exp_trunc[exp_trunc >= 4 & exp_trunc <= 7], exp_trunc)
  expect_setequal(gamma1_trunc[gamma1_trunc >= 1.5 & gamma1_trunc <= 2], gamma1_trunc)
  expect_setequal(gamma2_trunc[gamma2_trunc >= 7 & gamma2_trunc <= 9], gamma2_trunc)
  expect_setequal(igamma1_trunc[igamma1_trunc >= .5 & igamma1_trunc <= .6], igamma1_trunc)
  expect_setequal(igamma2_trunc[igamma2_trunc >= .1 & igamma2_trunc <= .2], igamma2_trunc)
  expect_setequal(igauss_trunc[igauss_trunc >= 0 & igauss_trunc <= 1], igauss_trunc)
  expect_setequal(lnorm_trunc[lnorm_trunc >= 3 & lnorm_trunc <= 4], lnorm_trunc)
  expect_setequal(nbinom1_trunc[nbinom1_trunc >= 30 & nbinom1_trunc <= 40], nbinom1_trunc)
  expect_setequal(nbinom2_trunc[nbinom2_trunc >= 4 & nbinom2_trunc <= 6], nbinom2_trunc)
  expect_setequal(norm_trunc[norm_trunc >= 50 & norm_trunc <= 99], norm_trunc)
  expect_setequal(pois_trunc[pois_trunc >= 100 & pois_trunc <= 101], pois_trunc)
  expect_true(all(beta_diff < .2 | beta_diff > .6))
  expect_true(all(binom_diff < 1 | binom_diff > 3))
  expect_true(all(chisq_diff < 360 | chisq_diff > 390))
  expect_true(all(contb_diff < .4 | contb_diff > .7))
  expect_true(all(exp_diff < 4 | exp_diff > 7))
  expect_true(all(gamma1_diff < 1.5 | gamma1_diff > 2))
  expect_true(all(gamma2_diff < 7 | gamma2_diff > 9))
  expect_true(all(igamma1_diff < .5 | igamma1_diff > .6))
  expect_true(all(igamma2_diff < .1 | igamma2_diff > .2))
  expect_true(all(igauss_diff < 0 | igauss_diff > 1))
  expect_true(all(lnorm_diff < 3 | lnorm_diff > 4))
  expect_true(all(nbinom1_diff < 30 | nbinom1_diff > 40))
  expect_true(all(nbinom2_diff < 4 | nbinom2_diff > 6))
  expect_true(all(norm_diff < 50 | norm_diff > 99))
  expect_true(all(pois_diff < 100 | pois_diff > 101))
})
