% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.catchCurve.R
\name{plot.catchCurve}
\alias{plot.catchCurve}
\title{Plotting catch curve}
\usage{
\method{plot}{catchCurve}(
  x,
  xaxis = "age",
  plot_selec = FALSE,
  col = c("blue", "darkgreen", "orange", "darkred"),
  cex = 1.5,
  xlim = NULL,
  ylim = NULL,
  xlab = "default",
  ylab = "default",
  ...
)
}
\arguments{
\item{x}{A list of the class \code{"catchCurve"} containing the results of the
catchCurve model.}

\item{xaxis}{Character defining if x axis should represent length or age (default: 'age')}

\item{plot_selec}{logical; if TRUE the regression line is plotted for not fully
exploited length groups and the probability of capture is plotted. This
only works if the \link{catchCurve} was applied with
\code{calc_ogive} == TRUE.}

\item{col}{a specification for colour of regression points, line and annotation}

\item{cex}{a numerical value giving the amount by which plotting text and
symbols should be magnified relative to the default.}

\item{xlim}{limits of x axis}

\item{ylim}{limits of y axis}

\item{xlab}{label of x axis. Default display by setting to "default".}

\item{ylab}{label of y axis. Default display by setting to "default".}

\item{...}{standard parameters of plot function}
}
\description{
This function plots the results from the \code{\link{catchCurve}} model.
}
\details{
A function to plot the results of the catchCurve model.
}
\examples{
\dontrun{
data(synLFQ3)
output <- catchCurve(synLFQ3, calc_ogive = TRUE, reg_int = c(9,21))
plot(output, plot_selec = TRUE)
}

}
\references{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. FAO Fisheries Technical Paper, (306.1, Rev. 2). 407 p.
}
