% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.VPA.R
\name{plot.VPA}
\alias{plot.VPA}
\title{VPA plot}
\usage{
\method{plot}{VPA}(x, display_last_class = TRUE, ...)
}
\arguments{
\item{x}{list of the class \code{"VPA"} containing the results of the VPA model.}

\item{display_last_class}{logical; should last age/length class be displayed in graph?}

\item{...}{standard parameters of \code{\link{barplot}}}
}
\description{
This function plots the survivors, catches, natural losses, and fishing
   mortality resulting from the \link{VPA} model.
}
\examples{
data(whiting)
output <- VPA(whiting, terminalF = 0.5, analysis_type = "VPA")
plot(output, display_last_class = FALSE)

}
\references{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. FAO Fisheries Technical Paper, (306.1, Rev. 2). 407 p.
}

