% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msltrend.R
\name{gap.fillview}
\alias{gap.fillview}
\title{Inspect gap-filling options for mean sea level records.}
\usage{
gap.fillview(object, station_name = " ", fillgaps = 1)
}
\arguments{
\item{object}{an annual average mean sea level time series (refer \code{\link[stats]{ts}})
with water levels (in millimetres). Missing data must be denoted by \dQuote{NA}.
Missing data and maximum missing data gap are limited to 15\% and 5\%, respectively,
of the data record. These data input constraints have been based on the research
work of Watson (2018) to best preserve the integrity and primary characteristics
of the data set for mean sea level analysis. To ensure maximum flexibility for the
data analyst, gaps beyond these margins are permitted to be filled but a warning
will appear at the console when these advised limits are exceeded.  \cr


\strong{Warning: } If input data files do not conform to these pre-conditions,
the analysis will be terminated. It should be further noted that the existence
of long period oscillations in global mean sea level have been well recognised
in the literature (eg. Chambers et al. (2012); Minobe (1999)). Therefore, in
order to be effective for climate change and sea level research, time series
input files are recommended to have a minimum length of at least 80 years
in order that the analysis can identify and isloate such signals. Time series
less than 80 years in length will be analysed but a warning will be displayed.}

\item{station_name}{character string, providing the name of the data record.

\strong{Note: }This field can be left blank, however, it is retained for use
in banner labelling of all plotting and pdf outputs.}

\item{fillgaps}{numeric, provides 5 alternative gap filling procedures for
missing data. The following options are available:

\itemize{
  \item 1: The default procedure is based on iterative gap filling using
  Singular Spectrum Analysis (refer \code{\link[Rssa]{igapfill}});
  \item 2: linear interpolation (refer \code{\link[zoo]{na.approx}});
  \item 3: Cubic spline interpolation (refer \code{\link[zoo]{na.approx}});
  \item 4: Stineman's interpolation (refer \code{\link[imputeTS]{na.interpolation}}); and
  \item 5: Weighted moving average (refer \code{\link[imputeTS]{na.ma}}).
}

\strong{Note: }Gap filled portions of the time series are denoted in red on
the default screen plot. This is done specifically to provide ready visual
observation to discern if the selected gap filling method provides an
appropriate estimate within the gaps in keeping with the remainder of the
historical record. Depending on the nature of the record and extent of gaps,
some trial and error between alternatives might be necessary to optimise gap
filling.}
}
\value{
An object of class \dQuote{gap.fillview} is returned with the following
elements:
\describe{
 \item{\strong{$Station.Name: }}{the name of the data record.}
 \item{\strong{$Summary: }}{a summary data frame of relevant parameters
 relating to the inputted annual average data set and filled time series, including:}
 \itemize{
  \item{$Year: input data; }
  \item{$MSL: input data; }
  \item{$FilledTS: gap-filled time series. }
  }
}

 \describe{
 \item{\strong{$Fillgaps: }}{the procedure used to fill the time series.}
 }
}
\description{
Inspect gap-filling options for mean sea level records.
}
\details{
This function permits visual screen checking of various gap-filling
options prior to undertaking the full trend analysis (refer \code{\link{msl.trend}}).
The returned object can also be used directly as input to the \code{\link{custom.trend}}
function.
}
\examples{
# -------------------------------------------------------------------------
# View different options for filling the Baltimore annual mean sea level record.
# -------------------------------------------------------------------------

data(Balt) # Baltimore mean sea level record
ts1 <- ts(Balt[2], start = Balt[1, 1]) # create time series input object

g <- gap.fillview(ts1, station_name = "Baltimore", fillgaps = 1) # SSA
g <- gap.fillview(ts1, station_name = "Baltimore", fillgaps = 2) # Linear interpolation
g <- gap.fillview(ts1, station_name = "Baltimore", fillgaps = 3) # Cubic spline interpolation
g <- gap.fillview(ts1, station_name = "Baltimore", fillgaps = 4) # Stineman's interpolation
g <- gap.fillview(ts1, station_name = "Baltimore", fillgaps = 5) # Weighted moving average

str(g) # Check structure of outputted object

}
\references{
Chambers, D.P., Merrifield, M.A., and Nerem, R.S., 2012. Is there
a 60 year oscillation in global mean sea level? \emph{Geophysical Research Letters}, 39(18).

Minobe, S., 1999. Resonance in bidecadal and pentadecadal climate oscillations
over the North Pacific: Role in climatic regime shifts. \emph{Geophysical Research Letters},
26(7), pp.855-858.

Watson, P.J., 2018. \emph{Improved Techniques to Estimate Mean Sea Level,
Velocity and Acceleration from Long Ocean Water Level Time Series to Augment
Sea Level (and Climate Change) Research.} PhD Thesis, University of New South
Wales, Sydney, Australia.
}
\seealso{
\code{\link{msl.trend}}, \code{\link[Rssa]{igapfill}},
\code{\link[zoo]{na.approx}}, \code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.ma}}, \code{\link[stats]{ts}}.
}
