% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_comparison.R
\name{PairwiseDistances}
\alias{PairwiseDistances}
\title{Distances between each pair of trees}
\usage{
PairwiseDistances(trees, Func, valueLength = 1L, ...)
}
\arguments{
\item{trees}{List of trees of class \code{phylo}.}

\item{Func}{Function returning a distance between two trees.}

\item{valueLength}{Integer specifying expected length of the value returned
by \code{Func}.}

\item{\dots}{Additional arguments to \code{Func}.}
}
\value{
Matrix detailing distance between each pair of trees.
Identical trees are assumed to have zero distance.
}
\description{
Distances between each pair of trees
}
\examples{
trees <- list(BalancedTree(8), PectinateTree(8), StarTree(8))
TCIDiff <- function (tree1, tree2) {
  TotalCopheneticIndex(tree1) - TotalCopheneticIndex(tree2)
}
PairwiseDistances(trees, TCIDiff, 1)
TCIRange <- function (tree1, tree2) {
  range(TotalCopheneticIndex(tree1), TotalCopheneticIndex(tree2))
}
PairwiseDistances(trees, TCIRange, 2)
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{pairwise tree distances}
