% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RUtreebalance.R
\name{J1Index}
\alias{J1Index}
\alias{JQIndex}
\title{Robust universal tree balance index}
\usage{
J1Index(tree, q = 1, nonRootDominance = FALSE)

JQIndex(tree, q = 1, nonRootDominance = FALSE)
}
\arguments{
\item{tree}{Either an object of class 'phylo', or a dataframe with column
names Parent, Identity and (optionally) Population.
The latter is similar to \code{tree$edge}, where tree is an object of class
'phylo'; the differences are in class (data.frame versus matrix) and column
names.
The dataframe may (but isn't required to) include a row for the root node.
If population sizes are omitted then internal nodes will be assigned
population size zero and leaves will be assigned population size one.}

\item{q}{Numeric between zero and one specifying sensitivity to type
frequencies.  If \code{q < 1}, the \ifelse{html}{\out{J<sup>q</sup>}}{\eqn{J^q}}
index - based on generalized entropy - will be returned; see
\insertCite{Lemant2022;textual}{TreeTools}, page 1223.}

\item{nonRootDominance}{Logical specifying whether to use non-root dominance
factor.}
}
\description{
Calculate tree balance index \ifelse{html}{\out{J<sup>1</sup>}}{\eqn{J^1}}
(when \code{nonRootDominance = FALSE}) or
\ifelse{html}{\out{J<sup>1c</sup>}}{\eqn{J^{1c}}}
(when \code{nonRootDominance = TRUE}) from \insertRef{Lemant2022}{TreeTools}.
}
\details{
If population sizes are not provided, then the function assigns size 0 to
internal nodes, and size 1 to leaves.
}
\examples{
# Using phylo object as input:
phylo_tree <- read.tree(text="((a:0.1)A:0.5,(b1:0.2,b2:0.1)B:0.2);")
J1Index(phylo_tree)
phylo_tree2 <- read.tree(text='((A, B), ((C, D), (E, F)));')
J1Index(phylo_tree2)

# Using edges lists as input:
tree1 <- data.frame(Parent = c(1, 1, 1, 1, 2, 3, 4),
                    Identity = 1:7,
                    Population = c(1, rep(5, 6)))
J1Index(tree1)
tree2 <- data.frame(Parent = c(1, 1, 1, 1, 2, 3, 4),
                    Identity = 1:7,
                    Population = c(rep(0, 4), rep(1, 3)))
J1Index(tree2)
tree3 <- data.frame(Parent = c(1, 1, 1, 1, 2, 3, 4),
                    Identity = 1:7,
                    Population = c(0, rep(1, 3), rep(0, 3)))
J1Index(tree3)
cat_tree <- data.frame(Parent = c(1, 1:14, 1:15, 15),
                       Identity = 1:31,
                       Population = c(rep(0, 15), rep(1, 16)))
J1Index(cat_tree)

# If population sizes are omitted then internal nodes are assigned population
# size zero and leaves are assigned population size one:
sym_tree1 <- data.frame(Parent = c(1, rep(1:15, each = 2)),
                       Identity = 1:31,
                       Population = c(rep(0, 15), rep(1, 16)))
# Equivalently:                        
sym_tree2 <- data.frame(Parent = c(1, rep(1:15, each = 2)),
                       Identity = 1:31)
J1Index(sym_tree1)
J1Index(sym_tree2)
}
\references{
\insertAllCited{}
}
\seealso{
Other tree characterization functions: 
\code{\link{CladisticInfo}()},
\code{\link{Consensus}()},
\code{\link{Stemwardness}},
\code{\link{TotalCopheneticIndex}()}
}
\author{
Rob Noble, adapted by Martin R. Smith
}
\concept{tree characterization functions}
