% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem_segmentation_methods.R
\name{sgt.ransac.circle}
\alias{sgt.ransac.circle}
\title{Stem segmentation algorithm: RANSAC circle fit}
\usage{
sgt.ransac.circle(tol = 0.1, n = 10, conf = 0.99, inliers = 0.8)
}
\arguments{
\item{tol}{\code{numeric} - tolerance offset between absolute radii estimates and hough transform estimates.}

\item{n}{\code{numeric} - number of points selected on every RANSAC iteration.}

\item{conf}{\code{numeric} - confidence level.}

\item{inliers}{\code{numeric} - expected proportion of inliers among stem segments' point cloud chunks.}
}
\description{
This function is meant to be used inside \code{\link{stemSegmentation}}. It applies a least squares circle fit algorithm in a RANSAC fashion over stem segments. More details are given in the sections below.
}
\section{Random Sample Consensus (RANSAC) Algorithm}{


\loadmathjax

The \strong{RAN}dom \strong{SA}mple \strong{C}onsensus algorithm is a method that relies on resampling 
a data set as many times as necessary to find a subset comprised of only inliers - e.g. observations
belonging to a desired model. The RANSAC algorithm provides a way of estimating the necessary number of
iterations necessary to fit a model using inliers only, at least once, as shown in the equation:
\mjdeqn{k = log(1 - p) / log(1 - w^{n})}{k = log(1 - p) / log(1 - w^n)}
where:
\itemize{
\item \emph{k}: number of iterations
\item \emph{p}: confidence level, i.e. desired probability of success 
\item \emph{w}: proportion of inliers expected in the \emph{full} dataset
\item \emph{n}: number of observations sampled on every iteration
}

The models reiterated in \emph{TreeLS} usually relate to circle or cylinder 
fitting over a set of 3D coordinates, selecting the best possible model through the RANSAC algorithm

For more information, checkout \href{https://en.wikipedia.org/wiki/Random_sample_consensus}{this wikipedia page}.
}

\section{Least Squares Circle Fit}{


The circle fit methods applied in \emph{TreeLS} estimate the circle parameters (its center's XY coordinates and radius)
from a pre-selected (denoised) set of points in a least squares fashion
by applying either \href{https://en.wikipedia.org/wiki/QR_decomposition}{QR decompostion}, used in combination
with the RANSAC algorithm, or \href{https://en.wikipedia.org/wiki/Nelder-Mead_method}{Nelder-Mead simplex}
optimization combined the IRLS approach.

The parameters returned by the circle fit methods are:
\itemize{
   \item \code{X,Y}: 2D circle center coordinates
   \item \code{Radius}: 2D circle radius, in point cloud units
   \item \code{Error}: model circle error from the least squares fit
   \item \code{AvgHeight}: average height of the stem segment's points
   \item \code{N}: number of points belonging to the stem segment
 }
}

\references{
Olofsson, K., Holmgren, J. & Olsson, H., 2014. Tree stem and height measurements using terrestrial laser scanning and the RANSAC algorithm. Remote Sensing, 6(5), pp.4323–4344.

Conto, T. et al., 2017. Performance of stem denoising and stem modelling algorithms on single tree point clouds from terrestrial laser scanning. Computers and Electronics in Agriculture, v. 143, p. 165-176.
}
