% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-gamma.R
\name{util_gamma_aic}
\alias{util_gamma_aic}
\title{Calculate Akaike Information Criterion (AIC) for Gamma Distribution}
\usage{
util_gamma_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a gamma distribution.}
}
\value{
The AIC value calculated based on the fitted gamma distribution to the provided data.
}
\description{
This function estimates the shape and scale parameters of a gamma distribution
from the provided data using maximum likelihood estimation, and then calculates
the AIC value based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a gamma
distribution fitted to the provided data.

This function fits a gamma distribution to the provided data using maximum
likelihood estimation. It estimates the shape and scale parameters of the
gamma distribution using maximum likelihood estimation. Then, it calculates
the AIC value based on the fitted distribution.

Initial parameter estimates: The function uses the method of moments
estimates as starting points for the shape and scale parameters of the
gamma distribution.

Optimization method: The function uses the optim function for optimization.
You might explore different optimization methods within optim for potentially
better performance.

Goodness-of-fit: While AIC is a useful metric for model comparison, it's
recommended to also assess the goodness-of-fit of the chosen model using
visualization and other statistical tests.
}
\examples{
# Example 1: Calculate AIC for a sample dataset
set.seed(123)
x <- rgamma(30, shape = 1)
util_gamma_aic(x)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
