% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-convert-to-ts.R
\name{convert_to_ts}
\alias{convert_to_ts}
\title{Convert Data to Time Series Format}
\usage{
convert_to_ts(.data, .return_ts = TRUE, .pivot_longer = FALSE)
}
\arguments{
\item{.data}{A data frame or tibble to be converted into a time series format.}

\item{.return_ts}{A logical value indicating whether to return the time series data. Default is TRUE.}

\item{.pivot_longer}{A logical value indicating whether to pivot the data into long format. Default is FALSE.}
}
\value{
The function returns the processed data based on the chosen options:
\itemize{
\item If \code{ret_ts} is set to TRUE, it returns time series data.
\item If \code{pivot_longer} is set to TRUE, it returns the data in long format.
\item If both options are set to FALSE, it returns the data as a tibble.
}
}
\description{
This function converts data in a data frame or tibble into a time series format. It is designed to
work with data generated from \code{tidy_} distribution functions. The function can return time series data, pivot it
into long format, or both.
}
\details{
The function takes a data frame or tibble as input and processes it based on the specified options.
It performs the following actions:
\enumerate{
\item Checks if the input is a data frame or tibble; otherwise, it raises an error.
\item Checks if the data comes from a \code{tidy_} distribution function; otherwise, it raises an error.
\item Converts the data into a time series format, grouping it by "sim_number" and transforming the "y" column into a time series.
\item Returns the result based on the chosen options:
\itemize{
\item If \code{ret_ts} is set to TRUE, it returns the time series data.
\item If \code{pivot_longer} is set to TRUE, it pivots the data into long format.
\item If both options are set to FALSE, it returns the data as a tibble.
}
}
}
\examples{
# Example 1: Convert data to time series format without returning time series data
x <- tidy_normal()
result <- convert_to_ts(x, FALSE)
head(result)

# Example 2: Convert data to time series format and pivot it into long format
x <- tidy_normal()
result <- convert_to_ts(x, FALSE, TRUE)
head(result)

# Example 3: Convert data to time series format and return the time series data
x <- tidy_normal()
result <- convert_to_ts(x)
head(result)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
