% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est-param-burr.R
\name{util_burr_param_estimate}
\alias{util_burr_param_estimate}
\title{Estimate Burr Parameters}
\usage{
util_burr_param_estimate(.x, .auto_gen_empirical = TRUE)
}
\arguments{
\item{.x}{The vector of data to be passed to the function. Must be non-negative
integers.}

\item{.auto_gen_empirical}{This is a boolean value of TRUE/FALSE with default
set to TRUE. This will automatically create the \code{tidy_empirical()} output
for the \code{.x} parameter and use the \code{tidy_combine_distributions()}. The user
can then plot out the data using \verb{$combined_data_tbl} from the function output.}
}
\value{
A tibble/list
}
\description{
This function will attempt to estimate the Burr prob parameter
given some vector of values \code{.x}. The function will return a list output by default,
and  if the parameter \code{.auto_gen_empirical} is set to \code{TRUE} then the empirical
data given to the parameter \code{.x} will be run through the \code{tidy_empirical()}
function and combined with the estimated Burr data.
}
\details{
This function will see if the given vector \code{.x} is a numeric vector.
It will attempt to estimate the prob parameter of a Burr distribution.
}
\examples{
library(dplyr)
library(ggplot2)

tb <- tidy_burr(.shape1 = 1, .shape2 = 2, .rate = .3) |> pull(y)
output <- util_burr_param_estimate(tb)

output$parameter_tbl

output$combined_data_tbl |>
  tidy_combined_autoplot()

}
\seealso{
Other Parameter Estimation: 
\code{\link{util_bernoulli_param_estimate}()},
\code{\link{util_beta_param_estimate}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_cauchy_param_estimate}()},
\code{\link{util_exponential_param_estimate}()},
\code{\link{util_gamma_param_estimate}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_hypergeometric_param_estimate}()},
\code{\link{util_logistic_param_estimate}()},
\code{\link{util_lognormal_param_estimate}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_pareto_param_estimate}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_triangular_param_estimate}()},
\code{\link{util_uniform_param_estimate}()},
\code{\link{util_weibull_param_estimate}()}

Other Burr: 
\code{\link{tidy_burr}()},
\code{\link{tidy_inverse_burr}()},
\code{\link{util_burr_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Burr}
\concept{Parameter Estimation}
