% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est-param-hypergeometric.R
\name{util_hypergeometric_param_estimate}
\alias{util_hypergeometric_param_estimate}
\title{Estimate Hypergeometric Parameters}
\usage{
util_hypergeometric_param_estimate(
  .x,
  .m = NULL,
  .total = NULL,
  .k,
  .auto_gen_empirical = TRUE
)
}
\arguments{
\item{.x}{A non-negative integer indicating the number of white balls out of a
sample of size \code{.k} drawn without replacement from the urn.
You cannot have missing, undefined or infinite values.}

\item{.m}{Non-negative integer indicating the number of white balls in the urn.
You must supply \code{.m} or \code{.total}, but not both. You cannot have missing values.}

\item{.total}{A positive integer indicating the total number of balls in the
urn (i.e., m+n). You must supply \code{.m} or \code{.total}, but not both. You cannot
have missing values.}

\item{.k}{A positive integer indicating the number of balls drawn without
replacement from the urn. You cannot have missing values.}

\item{.auto_gen_empirical}{This is a boolean value of TRUE/FALSE with default
set to TRUE. This will automatically create the \code{tidy_empirical()} output
for the \code{.x} parameter and use the \code{tidy_combine_distributions()}. The user
can then plot out the data using \verb{$combined_data_tbl} from the function output.}
}
\value{
A tibble/list
}
\description{
This function will attempt to estimate the geometric prob parameter
given some vector of values \code{.x}. Estimate m, the number of white balls in
the urn, or m+n, the total number of balls in the urn, for a hypergeometric
distribution.
}
\details{
This function will see if the given vector \code{.x} is a numeric integer.
It will attempt to estimate the prob parameter of a geometric distribution.
Missing (NA), undefined (NaN), and infinite (Inf, -Inf) values are not allowed.
Let \code{.x} be an observation from a hypergeometric distribution with parameters
\code{.m} = \code{M}, .\code{n} = \code{N}, and \code{.k} = \code{K}. In R nomenclature, .\code{x} represents
the number of white balls drawn out of a sample of \code{.k} balls drawn without
replacement from an urn containing \code{.m} white balls and \code{.n} black balls.
The total number of balls in the urn is thus \code{.m} + \code{.n}. Denote the total
number of balls by \code{T} = \code{.m} + \code{.n}
}
\examples{
library(dplyr)
library(ggplot2)

th <- rhyper(10, 20, 30, 5)
output <- util_hypergeometric_param_estimate(th, .total = 50, .k = 5)

output$parameter_tbl

output$combined_data_tbl \%>\%
  tidy_combined_autoplot()

}
\seealso{
Other Parameter Estimation: 
\code{\link{util_bernoulli_param_estimate}()},
\code{\link{util_beta_param_estimate}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_cauchy_param_estimate}()},
\code{\link{util_exponential_param_estimate}()},
\code{\link{util_gamma_param_estimate}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_logistic_param_estimate}()},
\code{\link{util_lognormal_param_estimate}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_pareto_param_estimate}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_uniform_param_estimate}()},
\code{\link{util_weibull_param_estimate}()}

Other Hypergeometric: 
\code{\link{tidy_hypergeometric}()},
\code{\link{util_hypergeometric_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Hypergeometric}
\concept{Parameter Estimation}
