% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signT.R
\name{fit_nonparaT}
\alias{fit_nonparaT}
\title{Main function for nonparametric tensor estimation and completion based on low sign rank model.}
\usage{
fit_nonparaT(Y,truer,H,Lmin,Lmax,option = 2)
}
\arguments{
\item{Y}{A given (possibly noisy and incomplete) data tensor. The function allows both continuous- and binary-valued tensors. Missing value should be encoded as \code{NA}.}

\item{truer}{Sign rank of the signal tensor.}

\item{H}{Resolution parameter.}

\item{Lmin}{Minimum value of the signal tensor (or minimum value of the tensor Y).}

\item{Lmax}{Maximum value of the signal tensor (or maximum value of the tensor Y).}

\item{option}{A large margin loss to be used. Use logistic loss if \code{option} = 1, hinge loss if \code{option} = 2. Hinge loss is default.}
}
\value{
The returned object is a list of components.

\code{fitted} - A series of optimizers that minimize the weighted classification loss at each level.

\code{est} - An estimated signal tensor based on nonparametic tensor method via sign series.
}
\description{
Estimate a signal tensor from a noisy and incomplete data tensor using nonparametric tensor method via sign series.
}
\examples{
library(tensorregress)
indices = c(2,2,2)
noise = rand_tensor(indices)@data
Theta = array(runif(prod(indices),min=-2,max = 2),indices)

# The signal plus noise model
Y = Theta + noise

# Estimate Theta from nonparametic completion method via sign series
hatTheta = fit_nonparaT(Y,truer = 2,H = 2,Lmin = -2,Lmax = 2, option =2)
print(hatTheta$est)

}
\references{
C. Lee and M. Wang. Beyond the Signs: Nonparametric Tensor Completion via Sign Series. \emph{arXiv preprint arXiv:2102.00384}, 2021.
}
