% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluating.r
\name{evaluate}
\alias{evaluate}
\alias{evaluate.evaluating}
\alias{evaluate.fitness}
\alias{evaluate.error}
\title{Evaluating prediction/modeling quality}
\usage{
evaluate(obj, ...)

\method{evaluate}{evaluating}(obj, test, pred, ...)

\method{evaluate}{fitness}(obj, mdl, test = NULL, pred = NULL, ...)

\method{evaluate}{error}(obj, mdl = NULL, test = NULL, pred = NULL, ..., fitness = FALSE)
}
\arguments{
\item{obj}{An object of class \code{\link{evaluating}} defining a particular metric.}

\item{...}{Other parameters passed to \code{eval_func} of \code{obj}.}

\item{test}{A vector or univariate time series containing actual values
for a time series that are to be compared against \code{pred}.}

\item{pred}{A vector or univariate time series containing time series
predictions that are to be compared against the values in \code{test}.}

\item{mdl}{A time series model object for which fitness is to be evaluated.}

\item{fitness}{Should the function compute the fitness quality? If \code{TRUE} the function
uses \code{mdl} to compute fitness error, otherwise, it uses \code{test} and 
\code{pred} to compute prediction error.

For \code{evaluate.fitness}, \code{test} and \code{pred} are ignored and can be set to \code{NULL}.
For \code{evaluate.error}, \code{mdl} is ignored if \code{fitness} is \code{FALSE}, otherwise,
\code{test} and \code{pred} are ignored and can be set to \code{NULL}.}
}
\value{
A list containing \code{obj} and the computed metric values.
}
\description{
\code{evaluate} is a generic function for evaluating the quality of time series prediction
or modeling fitness based on a particular metric defined in an \code{\link{evaluating}} object.
The function invokes particular \emph{methods} which
depend on the class of the first argument.
}
\examples{
data(CATS,CATS.cont)
mdl <- forecast::auto.arima(CATS[,1])
pred <- forecast::forecast(mdl, h=length(CATS.cont[,1]))

evaluate(MSE_eval(), test=CATS.cont[,1], pred=pred$mean)
evaluate(MSE_eval(), mdl, fitness=TRUE)
evaluate(AIC_eval(), mdl)

}
\seealso{
Other evaluate: 
\code{\link{evaluate.tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{evaluate}
\keyword{evaluation}
\keyword{metric}
\keyword{quality}
