% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspred.r
\name{tspred}
\alias{tspred}
\title{Time series prediction process}
\usage{
tspred(
  subsetting = NULL,
  processing = NULL,
  modeling = NULL,
  evaluating = NULL,
  data = NULL,
  n.ahead = NULL,
  one_step = FALSE,
  ...,
  subclass = NULL
)
}
\arguments{
\item{subsetting}{A \code{\link{subsetting}} object regarding subsetting processing.}

\item{processing}{List of named \code{\link{processing}} objects used for pre(post)processing the data.}

\item{modeling}{A \code{\link{modeling}} object used for time series modeling and prediction.}

\item{evaluating}{List of named \code{\link{evaluating}} objects used for prediction/modeling quality evaluation.}

\item{data}{A list of time series to be pre(post)processed, modelled and/or predicted.}

\item{n.ahead}{Integer defining the number of observations to be predicted.}

\item{one_step}{Should the function produce one-step ahead predictions?
If \code{FALSE}, a multi-step ahead prediction approach is adopted.}

\item{...}{Other parameters to be encapsulated in the class object.}

\item{subclass}{Name of new specialized subclass object created in case it is provided.}
}
\value{
An object of class \code{tspred}.
}
\description{
Constructor for the \code{tspred} class representing a time series prediction
process. This process may involve subsetting the time series data into training and testing sets,
preprocessing/postprocessing the data, modeling, prediction and finally an evaluation
of modeling fitness and prediction quality. All these process steps should be based on
particular time series transformation methods, a modeling and prediction method, and quality metrics
which are defined in a \code{tspred} class object.
}
\examples{
	 #Obtaining objects of the processing class
  proc1 <- subsetting(test_len=20)
  proc2 <- BoxCoxT(lambda=NULL)
  proc3 <- WT(level=1, filter="bl14")

  #Obtaining objects of the modeling class
  modl1 <- ARIMA()

  #Obtaining objects of the evaluating class
  eval1 <- MSE_eval()
  eval2 <- MAPE_eval()

  #Defining a time series prediction process
  tspred_1 <- tspred(subsetting=proc1,
                     processing=list(BCT=proc2, 
                                     WT=proc3), 
                     modeling=modl1,
                     evaluating=list(MSE=eval1,
                                     MAPE=eval2)
                    )
  summary(tspred_1)

	 #Obtaining objects of the processing class
  proc4 <- SW(window_len = 6)
  proc5 <- MinMax()
  
  #Obtaining objects of the modeling class
  modl2 <- NNET(size=5,sw=proc4,proc=list(MM=proc5))
  
  #Defining a time series prediction process
  tspred_2 <- tspred(subsetting=proc1,
                     processing=list(BCT=proc2, 
                                     WT=proc3),
                     modeling=modl2,
                     evaluating=list(MSE=eval1,
                                     MAPE=eval2)
                    )
  summary(tspred_2)

}
\seealso{
Other constructors: 
\code{\link{ARIMA}()},
\code{\link{LT}()},
\code{\link{MSE_eval}()},
\code{\link{evaluating}()},
\code{\link{modeling}()},
\code{\link{processing}()}
}
\author{
Rebecca Pontes Salles
}
\concept{constructors}
\keyword{evaluate}
\keyword{model}
\keyword{prediction}
\keyword{preprocess}
\keyword{tspred}
