% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.r
\name{train_test_subset}
\alias{train_test_subset}
\title{Get training and testing subsets of data}
\usage{
train_test_subset(data, train_perc = 0.8, test_len = NULL)
}
\arguments{
\item{data}{A numeric vector, time series, data.frame or matrix containg data to be subsetted.}

\item{train_perc}{Percentage of data observations to compose the training dataset.
Ignored if \code{test_len} is given.}

\item{test_len}{Required length of testing dataset. If \code{NULL}, \code{1-train_perc} is used 
for computing the number of data observations in the testing dataset.}
}
\value{
A list with train and test subsets of data.
}
\description{
Function subsets data into training and testing datasets.
}
\examples{

data(CATS)
d <- train_test_subset(CATS[,1])

swin <- sw(CATS[,1],5)
d_sw <- train_test_subset(swin)

}
\seealso{
Other transformation methods: 
\code{\link{Diff}()},
\code{\link{LogT}()},
\code{\link{WaveletT}()},
\code{\link{emd}()},
\code{\link{mas}()},
\code{\link{mlm_io}()},
\code{\link{outliers_bp}()},
\code{\link{pct}()}
}
\author{
Rebecca Pontes Salles
}
\concept{transformation methods}
\keyword{data}
\keyword{subsets}
\keyword{test}
\keyword{train}
