% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspred.r
\name{train.tspred}
\alias{train.tspred}
\title{Train method for \code{\link{tspred}} objects}
\usage{
\method{train}{tspred}(obj, ...)
}
\arguments{
\item{obj}{An object of class \code{\link{tspred}} defining a particular time series prediction process.}

\item{...}{Ignored}
}
\value{
An object of class \code{tspred} with updated structure containing
the produced trained time series models.
}
\description{
Fits a model to the time series data contained in a \code{\link{tspred}} class object
based on a particular model training method. The model training method is defined
by a \code{\link{modeling}} object contained in the \code{\link{tspred}} class object.
}
\details{
The function \code{\link{train.tspred}} calls the method \code{\link{train}} 
on the \code{\link{modeling}} object for each time series contained in \code{obj}.
Finally, the produced time series model is introduced in the structure of the 
\code{\link{tspred}} class object in \code{obj}.

If any modeling parameters are computed during training, they are duly updated
in the structure of the \code{\link{tspred}} class object in \code{obj}. This is important
for provenance and reprodutibility of the training process.
}
\examples{
data(CATS)

#Obtaining objects of the processing class
proc1 <- subsetting(test_len=20)
proc2 <- BoxCoxT(lambda=NULL)
proc3 <- WT(level=1, filter="bl14")

#Obtaining objects of the modeling class
modl1 <- ARIMA()

#Obtaining objects of the evaluating class
eval1 <- MSE_eval()

#Defining a time series prediction process
tspred_1 <- tspred(subsetting=proc1,
                   processing=list(BCT=proc2,
                                   WT=proc3), 
                   modeling=modl1,
                   evaluating=list(MSE=eval1)
)
summary(tspred_1)

tspred_1 <- subset(tspred_1, data=CATS[3])
tspred_1 <- preprocess(tspred_1,prep_test=FALSE)
tspred_1 <- train(tspred_1)

}
\seealso{
[tspred()] for defining a particular time series prediction process,
and [ARIMA()] for defining a time series modeling and prediction method.

Other train: 
\code{\link{train}()}
}
\author{
Rebecca Pontes Salles
}
\concept{train}
\keyword{model}
\keyword{training}
