% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discriminant.R
\name{trainModel.array}
\alias{trainModel.array}
\title{Generates a discriminant model from training data.}
\usage{
\method{trainModel}{array}(
  data,
  labels,
  f,
  method,
  maxvars,
  VStep,
  lev = 0,
  features = c("Var", "Cor", "IQR", "PE", "DM"),
  nCores = 0,
  ...
)
}
\arguments{
\item{data}{Sample from the population (dim x length x cases)}

\item{labels}{Labeled vector that classify the observations}

\item{f}{Selected filter for the MODWT (to see the available filters use the
function availableFilters)}

\item{method}{Selected method for the discriminant. Valid values
"linear" "quadratic"}

\item{maxvars}{Maximum number of variables included by the StepDiscrim
algorithm (Note that if you defined this, can not define VStep). Must
be a positive integer greater than 0.}

\item{VStep}{Minimum value of V above which all other variables are
considered irrelevant and therefore will not be included. (Note that
if you defined this, can not defined maxvars).Must be a positive
number greater than 0. For more information see StepDiscrim
documentation}

\item{lev}{Determines the number of decomposition levels for MODWT
(by default the optimum is calculated). Must be a positive integer}

\item{features}{A list of characteristics that will be used for the
classification process. To see the available features
see \code{\link{availableFeatures}}}

\item{nCores}{Determines the number of processes that will be used in the
function, by default it uses all but one of the system cores. Must be
a positive integer, where 0 corresponds to the default behavior.}

\item{...}{Additional arguments}
}
\value{
A discriminant model object (lda or qda)
}
\description{
It generates a discriminant model starting from the training data, which must
be provided in 2 groups depending on their classification. The method first
obtains the variances and correlations using MODWT, the f filter is applied
with a number of levels lev. Then a subset of all the generated features
will be obtained by means of a stepwise discriminant, which can be driven
by a maximum number of features or by a minimum metric to be met. Finally,
the selected discriminant model is trained with the subset obtained.
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
# The dataset has the first 5 elements of class 1 and the last 5 of class 2.
labels <- c(rep(1, 5), rep(2, 5))
model <- trainModel(ECGExample, labels, "d6", "linear",
  maxvars = 5, features = c("Var")
)
# or using VStep
modelV <- trainModel(ECGExample, labels, "d6", "linear",
    VStep = 14.5, features = c("Var")
)
}
}
\seealso{
\itemize{
\item \code{\link{StepDiscrim}}
\item \code{\link{StepDiscrimV}}
\item \code{\link{trainModel}}
}
}
