% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discriminant.R
\name{KFCV.array}
\alias{KFCV.array}
\title{Generates and validates a discriminant model generated directly from the
data.}
\usage{
\method{KFCV}{array}(
  data,
  labels,
  f,
  method,
  maxvars,
  VStep,
  k = 5L,
  lev = 0L,
  features = c("Var", "Cor", "IQR", "PE", "DM"),
  returnClassification = FALSE,
  nCores = 0,
  ...
)
}
\arguments{
\item{data}{Sample from the population (dim x length x cases)}

\item{labels}{Labeled vector that classify the observations}

\item{f}{Selected filter for the MODWT (to see the available filters use the
function \code{\link{availableFilters}}}

\item{method}{Selected method for the discriminant.
Valid values "linear" "quadratic"}

\item{maxvars}{Maximum number of variables included by the StepDiscrim
algorithm (Note that if you defined this, can not define VStep).
Must be a positive integer greater than 0.}

\item{VStep}{Minimum value of V above which all other variables are
considered irrelevant and therefore will not be included. (Note that
if you defined this, can not defined maxvars). Must be a positive
number and greater than 0. For more information see StepDiscrim
documentation}

\item{k}{The number of folds in KFCV. Must be a positive integer lower or
equal than the number of observations}

\item{lev}{Determines the number of decomposition levels for MODWT
(by default the optimum is calculated using the "conservative"
strategy). Must be a positive integer (including 0 to auto-select
the level)}

\item{features}{A list of characteristics that will be used for the
classification process. To see the available features see
\code{\link{availableFeatures}}}

\item{returnClassification}{Allows to select if the raw result classification
is returned.}

\item{nCores}{Determines the number of processes that will be used in the
function, by default it uses all but one of the system cores. Must be
a positive integer, where 0 corresponds to the default behavior.}

\item{...}{Additional arguments}
}
\value{
\itemize{
\item if returnClassification is false return a object of class
confusionMatrix
\item if returnClassification is true, it returns a list containing an
object of the confusionMatrix class and a vector with the
classification result.
}
}
\description{
It generates and validates a discriminant model starting from the data. First
, a MultiWaveAnalysis object is obtained according to the selected characteristics
,filter and levels. Then, the most important features are selected using a
stepwise discriminant that allows to select a maximum number of variables
(maxvars) or a minimum enhancement step (VStep). Finally, the model is
trained using the subset of features and validated using
K-Fold Cross Validation (KFCV).
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
labels <- c(rep(1, 5), rep(2, 5))
CM <- KFCV(ECGExample, labels, "haar", "linear",
  maxvars = 5,
  features = c("Var"), returnClassification = FALSE
)
# or with VStep
CMV <- KFCV(ECGExample, labels, "haar", "linear",
 k = 5,
 VStep = 5,
 features = c("Var"), returnClassification = FALSE
)
}
}
\seealso{
\itemize{
\item \code{\link{LOOCV}}
\item \code{\link{LOOCV.MultiWaveAnalysis}}
\item \code{\link{availableFilters}}
\item \code{\link{availableFeatures}}
}
}
