% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRR_sim.R
\name{TRR_sim}
\alias{TRR_sim}
\title{Generate simulation data for tensor response regression (TRR)}
\usage{
TRR_sim(r, p, u, n)
}
\arguments{
\item{r}{The dimension of response, a vector with length larger than 2.}

\item{p}{The dimension of predictor, a scale.}

\item{u}{The structural dimension of envelopes at each mode, a vector with the same length as r.}

\item{n}{The sample size.}
}
\value{
\item{x}{The predictor of dimension \eqn{p\times n}}
\item{y}{The response of dimension \eqn{r_1\times \cdots\times r_m \times n}}
\item{Gamma}{The envelope subspace basis of dimension \eqn{r_k \times u_k, \ k=1,\ldots,m}}
\item{coefficients}{The tensor coefficients of dimension \eqn{r_1\times \cdots\times r_m \times p}}
\item{Sigma}{A lists of estimated covariance matrices at each mode for the error term, i.e., \eqn{\boldsymbol{\Sigma}_1,\dots,\boldsymbol{\Sigma}_m}.}
\item{p, r, u}{The input \code{p,r,u}}
}
\description{
This function is used to generate simulation data used in tensor response regression.
}
\details{
The tensor response regression model is of the form,
\deqn{\mathbf{Y} = \mathbf{B}\bar{\times}_{(m+1)}\mathbf{X} +\boldsymbol{\varepsilon}}
where predictor \eqn{\mathbf{X} \in R^{p}}, response \eqn{\mathbf{Y} \in R^{r_1\times \cdots\times r_m}}, and
the error term is tensor normal distributed
\deqn{\boldsymbol{\varepsilon}\sim TN(0;\boldsymbol{\Sigma}_1,\dots,\boldsymbol{\Sigma}_m)}
According to the tensor envelope structure, we have
\deqn{\mathbf{B} = [\Theta;\boldsymbol{\Gamma}_1,\ldots,\boldsymbol{\Gamma}_m,\mathbf{I}_p], \quad \mbox{for some } \boldsymbol{\Theta} \in R^{u_1\times\cdots\times u_m \times p}}
\deqn{\boldsymbol{\Sigma}_k = \boldsymbol{\Gamma}_k\boldsymbol{\Omega}_k\boldsymbol{\Gamma}_k^{T}+\boldsymbol{\Gamma}_{0k}\boldsymbol{\Omega}_{0k}\boldsymbol{\Gamma}_{0k}^\top,
\quad \mbox{for some } \boldsymbol{\Omega}_k, \boldsymbol{\Omega}_{0k},\ k=1,\ldots,m.}
}
\note{
The length of r must match the length of u, and each element of u must be less than the corresponding element in r.
}
\examples{
r <- c(10, 10, 10)
u <- c(2, 2, 2)
p <- 5
n <- 100
dat <- TRR_sim(r = r, p = p, u = u, n = n)
x <- dat$x
y <- dat$y
fit_std <- TRR.fit(x, y, method="standard")

}
\references{
Li L, Zhang X (2017). “Parsimonious Tensor Response Regression.” Journal of the American Statistical Association, 112(519), 1131–1146.
}
\seealso{
\code{\link{TPR.fit}, \link{TPR_sim}}.
}
