% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.Tenv.R
\name{summary.Tenv}
\alias{summary.Tenv}
\alias{print.summary.Tenv}
\title{Summarize method for Tenv object.}
\usage{
\method{summary}{Tenv}(object, ...)

\method{print}{summary.Tenv}(x, ...)
}
\arguments{
\item{object}{An object of class "Tenv", as from \code{\link{TPR.fit}} or \code{\link{TRR.fit}}.}

\item{...}{Arguments to be passed to or from other methods.}

\item{x}{An object of class "summary.Tenv", usually, a result of a call to summary.Tenv.}
}
\value{
Return \code{object} with additional components
 \item{n}{Sample size}
 \item{xdim}{Dimensions of predictor}
 \item{ydim}{Dimensions of response}
 \item{mse}{Mean squared error}
 \item{p_val}{Only for object returned from \code{\link{TRR.fit}}, p-value for coefficients}
 \item{se}{Only for object returned from \code{\link{TRR.fit}}, standard error for coefficients}
}
\description{
Summary method for object returned from \code{\link{TRR.fit}} and \code{\link{TPR.fit}} functions.
}
\details{
The \eqn{p}-value and the standard error of estimated coefficient are not provided for tensor predictor regression since they depend on \eqn{\widehat{\mathrm{cov}}^{-1}\{\mathrm{vec}(\mathbf{X})\}} which is unavailable due to the ultra-high dimension of \eqn{\mathrm{vec}(\mathbf{X})}.

print.summary.Tenv gives a more readable format of call, sample size, dimensions of datasets, mse. And if the \code{object} is returned from \code{\link{TRR.fit}}, then \code{p-val} and \code{se} are also returned.
}
\examples{
data("bat")
Xn <- bat$Xn
Yn <- bat$Yn
fit <- TRR.fit(Xn, Yn, method="standard")
##print summary
summary(fit)
}
\seealso{
\code{\link{Tenv_Pval}}
}
