% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCorrect.R
\name{AllPF}
\alias{AllPF}
\title{Fit all flow stress values in high strain conditions}
\usage{
AllPF(x, Manu = NULL, ...)
}
\arguments{
\item{x}{A data frame with \code{\link[VBTree:VBTree-package]{VBTree}} style. Pay attention, all factors in column names
should be separated by "-" symbol, and factors for temperatures and strain rates should be saved in pure numeric style.}

\item{Manu}{An integer vector with the length of 3 where the 1st element denotes the layer for Stress and Strain,
the 2nd and 3rd elements represent the levels for Strain and Stress, respectively. The default setting is NULL, which
can call the function \code{\link[TPMplt:lyIDdetector]{lyIDdetector}} for automatical completion this vector.}

\item{...}{The control parameters pass on to the function \code{\link[TPMplt:basicPF]{basicPF}}.}
}
\value{
A \code{\link[VBTree:VBTree-package]{VBTree}} style data frame with fitted values for flow stress in high strain conditions.
}
\description{
Fit all flow stress values in high strain conditions
}
\examples{
# Use multi-function fitting for curves
x <- AllPF(TPMdata, subsec = c(0.015, 0.2))
SSplots(x, 2, mfrow=c(2, 2))
}
\keyword{AllPF}
