% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetr_plot.R
\name{upsetr_plot}
\alias{upsetr_plot}
\title{UpSet plot for stat common and unique gene among multiple sets.}
\usage{
upsetr_plot(
  data,
  sets_num = 4,
  keep_order = FALSE,
  order_by = "freq",
  decrease = TRUE,
  mainbar_color = "#006600",
  number_angle = 45,
  matrix_color = "#cc0000",
  point_size = 4.5,
  point_alpha = 0.5,
  line_size = 0.8,
  shade_color = "#cdcdcd",
  shade_alpha = 0.5,
  setsbar_color = "#000066",
  setsnum_size = 6,
  text_scale = 1.2
)
}
\arguments{
\item{data}{Dataframe: Paired comparisons differentially expressed genes (degs) among groups (1st-col~: degs of paired comparisons).}

\item{sets_num}{Numeric: sets number. Default: 4, min: 2, max: NULL.}

\item{keep_order}{Logical: keep sets in the order entered using the sets parameter. Default: FALSE, options: TRUE, FALSE.}

\item{order_by}{Character: intersections in the matrix should be ordered by. Default: "freq" (frequency), options: "freq", "degree", "both".}

\item{decrease}{Logical: order by decrease. Default: TRUE, options: TRUE, FALSE.}

\item{mainbar_color}{Charactor: mainbar color (color name or hex value). Default: "#006600".}

\item{number_angle}{Numeric: number display angle. Default: 45, min: 0, max: 360.}

\item{matrix_color}{Charactor: matrix point color (color name or hex value). Default: "#cc0000".}

\item{point_size}{Numeric: point size. Default: 4.5, min: 0.0, max: NULL.}

\item{point_alpha}{Numeric: point color alpha. Default: 0.50, min: 0.00, max: 1.00.}

\item{line_size}{Numeric: connection line size. Default: 0.8, min: 0.00, max: NULL.}

\item{shade_color}{Character: matrix shade color. Default: "#cdcdcd".}

\item{shade_alpha}{Numeric: shade color alpha. Default: 0.50, min: 0.00, max: 1.00.}

\item{setsbar_color}{Character: sets bar color. Default: "#000066".}

\item{setsnum_size}{Numeric: sets bar number size. Default: 6.}

\item{text_scale}{Numeric: all text scale. Default: 1.2, min: 0.01, max: NULL.}
}
\value{
Plot: UpSet plot for stat common and unique gene among multiple sets.
}
\description{
UpSet plot for stat common and unique gene among multiple sets.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(degs_lists)
head(degs_lists)

# 3. Default parameters
upsetr_plot(degs_lists)

# 4. Set keep_order = TRUE, order_by = "degree"
upsetr_plot(degs_lists, keep_order = TRUE, order_by = "degree")

# 5. Set mainbar_color = "#333333", number_angle = 0
upsetr_plot(degs_lists, mainbar_color = "#333333", number_angle = 0)

# 6. Set shade_color = "#ffcc00", setsbar_color = "#0000cc"
upsetr_plot(degs_lists, shade_color = "#ffcc00", setsbar_color = "#0000cc")

}
\author{
benben-miao
}
