% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_enrich_stat.R
\name{go_enrich_stat}
\alias{go_enrich_stat}
\title{GO enrichment analysis and stat plot (None/Exist Reference Genome).}
\usage{
go_enrich_stat(
  go_anno,
  degs_list,
  padjust_method = "fdr",
  pvalue_cutoff = 0.05,
  qvalue_cutoff = 0.05,
  max_go_item = 15,
  strip_fill = "#CDCDCD",
  xtext_angle = 45,
  sci_fill_color = "Sci_AAAS",
  sci_fill_alpha = 0.8,
  ggTheme = "theme_light"
)
}
\arguments{
\item{go_anno}{Dataframe: GO and KEGG annotation of background genes (1st-col: Genes, 2nd-col: biological_process, 3rd-col: cellular_component, 4th-col: molecular_function, 5th-col: kegg_pathway).}

\item{degs_list}{Dataframe: degs list.}

\item{padjust_method}{Character: P-value adjust to Q-value. Default: "fdr" (false discovery rate), options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{pvalue_cutoff}{Numeric: P-value cutoff. Recommend: small than 0.05.}

\item{qvalue_cutoff}{Numeric: Q-value cutoff. Recommend: small than 0.05.}

\item{max_go_item}{Numeric: max BP/CC/MF terms. Default: 15, min: 1, max: NULL.}

\item{strip_fill}{Character: strip fill color (color name or hex value). Default: "#CDCDCD".}

\item{xtext_angle}{Numeric: x axis texts angle. Default: 45, min: 0, max: 360.}

\item{sci_fill_color}{Character: ggsci color pallet. Default: "Sci_AAAS", options: "Sci_AAAS", "Sci_NPG", "Sci_Simpsons", "Sci_JAMA", "Sci_GSEA", "Sci_Lancet", "Sci_Futurama", "Sci_JCO", "Sci_NEJM", "Sci_IGV", "Sci_UCSC", "Sci_D3", "Sci_Material".}

\item{sci_fill_alpha}{Numeric: ggsci fill color alpha. Default: 0.80, min: 0.00, max: 1.00.}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void"}
}
\value{
Plot: GO enrichment analysis and stat plot (None/Exist Reference Genome).
}
\description{
GO enrichment analysis and stat plot (None/Exist Reference Genome).
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_go_kegg)
head(gene_go_kegg)

# 3. Default parameters
go_enrich_stat(gene_go_kegg[,-5], gene_go_kegg[100:200,1])

# 4. Set padjust_method = "BH"
go_enrich_stat(gene_go_kegg[,-5], gene_go_kegg[100:200,1], padjust_method = "BH")

# 5. Set max_go_item = 10
go_enrich_stat(gene_go_kegg[,-5], gene_go_kegg[100:200,1], max_go_item = 10)

# 6. Set strip_fill = "#008888"
go_enrich_stat(gene_go_kegg[,-5], gene_go_kegg[100:200,1], strip_fill = "#008888")

# 7. Set sci_fill_color = "Sci_JAMA"
go_enrich_stat(gene_go_kegg[,-5], gene_go_kegg[100:200,1], sci_fill_color = "Sci_JAMA")

}
\author{
benben-miao
}
