% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_merge.R
\name{table_merge}
\alias{table_merge}
\title{Table merge used to merge multiple variables to on variable.}
\usage{
table_merge(
  data,
  merge_vars = c("Ozone", "Solar.R", "Wind", "Temp"),
  new_var = "Variable",
  new_value = "Value",
  na_remove = FALSE
)
}
\arguments{
\item{data}{Dataframe: include multiple variables (columns).}

\item{merge_vars}{Vector: include merged variable (column) names. Default: c("Ozone", "Solar.R", "Wind", "Temp") in example data.}

\item{new_var}{Character: new variable (column) name. Default: "Variable".}

\item{new_value}{Character: new variable (column) value name. Default: "Value".}

\item{na_remove}{Logical: remove NA value. Default: FALSE, options: TRUE, FALSE.}
}
\value{
Table: include multiple variables.
}
\description{
Table merge used to merge multiple variables to on variable.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(table_merge_data)
head(table_merge_data)

# 3. Default parameters
res <- table_merge(table_merge_data)
head(res)

# 4. Set merge_vars = c("Ozone", "Solar.R")
res <- table_merge(table_merge_data, merge_vars = c("Ozone", "Solar.R"))
head(res)

}
\author{
benben-miao
}
