% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_enrich.R
\name{go_enrich}
\alias{go_enrich}
\title{GO enrichment analysis based on GO annotation results (None/Exist Reference Genome).}
\usage{
go_enrich(
  go_anno,
  go_deg_fc,
  padjust_method = "fdr",
  pvalue_cutoff = 0.5,
  qvalue_cutoff = 0.5
)
}
\arguments{
\item{go_anno}{Dataframe: include columns (id, biological_process, cellular_component, molecular_function),  symbol ";" split GO terms.}

\item{go_deg_fc}{Dataframe: include columns (id, log2FC).}

\item{padjust_method}{Character: P-value adjust to Q-value. Default: "fdr" (false discovery rate), options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{pvalue_cutoff}{Numeric: P-value cutoff. Recommend: small than 0.05.}

\item{qvalue_cutoff}{Numeric: Q-value cutoff. Recommend: small than 0.05.}
}
\value{
Table: include columns ("ID", "ontology", "Description", "GeneRatio", "BgRatio", "pvalue", "p.adjust", "qvalue", "geneID", "Count").
}
\description{
GO enrichment analysis based on GO annotation results (None/Exist Reference Genome).
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(go_anno)
head(go_anno)

data(go_deg_fc)
head(go_deg_fc)

# 3. Default parameters
res <- go_enrich(go_anno, go_deg_fc)
head(res)

# 4. Set padjust_method = "BH"
res <- go_enrich(go_anno, go_deg_fc, padjust_method = "BH")
head(res)

# 5. Set pvalue_cutoff = 0.10
res <- go_enrich(go_anno, go_deg_fc, pvalue_cutoff = 0.10)
head(res)

}
\author{
benben-miao
}
