% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest.R
\name{as_htest}
\alias{as_htest}
\title{Convert to class 'htest'}
\usage{
as_htest(TOST)
}
\arguments{
\item{TOST}{A TOSTER result object of class 'TOSTt' or 'TOSTnp'.}
}
\value{
Returns a list containing a list of class 'htest' for the result of each test with the following elements:
\item{data.name}{A character string giving the names of the data.}
\item{estimate}{Estimated difference in raw units.}
\item{method}{A character string indicating the performed test.}
\item{null.value}{Equivalence bound.}
\item{alternative}{A character string describing the alternative hypothesis.}
\item{parameter}{The degrees of freedom of the distribution of the test statistic.}
\item{statistic}{The value of the test statistic.}
\item{p.value}{The p-value of the test.}
\item{conf.int}{The confidence interval of the difference.}
}
\description{
Convert a TOSTER result object of class 'TOSTt' or 'TOSTnp' to a list of class 'htest'.
}
\examples{
res1 = t_TOST(formula = extra ~ group,data = sleep,eqb = .5,smd_ci = "goulet")
as_htest(res1)
}
\seealso{
Other htest: 
\code{\link{htest-helpers}},
\code{\link{simple_htest}()}
}
\concept{htest}
