% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatostpaired.h.R
\name{dataTOSTpaired}
\alias{dataTOSTpaired}
\title{TOST Paired Samples T-Test}
\usage{
dataTOSTpaired(data, pairs, low_eqbound_dz = -0.5, high_eqbound_dz = 0.5,
  alpha = 0.05, desc = FALSE, plots = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{pairs}{a list of vectors of strings naming variables to pair from 
\code{data}}

\item{low_eqbound_dz}{lower equivalence bounds (e.g., -0.5) expressed in 
standardized mean difference (Cohen's dz)}

\item{high_eqbound_dz}{upper equivalence bounds (e.g., 0.5) expressed in 
standardized mean difference (Cohen's dz)}

\item{alpha}{alpha level (default = 0.05)}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive 
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide plots}
}
\description{
TOST Paired Samples T-Test
}
\section{References}{

Mara, C. A., & Cribbie, R. A. (2012). Paired-Samples Tests of Equivalence. Communications in Statistics - Simulation and Computation, 41(10), 1928-1943. https://doi.org/10.1080/03610918.2011.626545, formula page 1932. Note there is a typo in the formula: n-1 should be n (personal communication, 31-08-2016)
}

\examples{
library("TOSTER")

dataTOSTpaired(data = randu, pairs = list(c(i1="x",i2="y")), low_eqbound_dz = -0.3,
               high_eqbound_dz = 0.3, alpha = 0.05, desc = TRUE, plots = TRUE)

}
