% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM.bet.wit.ratio.R
\name{cluster.ratio_KM}
\alias{cluster.ratio_KM}
\title{Ratio of within and between tropical measures for k-means clusters}
\usage{
cluster.ratio_KM(A, C, method = "avg")
}
\arguments{
\item{A}{matrix of tropical points; rows are points}

\item{C}{number of clusters}

\item{method}{method to use for within cluster measure; "avg" or "max"}
}
\value{
vector of ratios for each cluster
}
\description{
Ratio of within and between cluster tropical measures for k-means derived clusters
}
\examples{

hars<-Sim_points
cls<-c(rep(1,50),rep(2,50),rep(3,50))
cl_pt<-cbind(hars,cls)

C<-3
cluster.ratio_KM(cl_pt,C,method='avg')
}
\references{
David Barnhill, Ruriko Yoshida (2023). Clustering Methods Over the Tropically Convex Sets.
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
