% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmbprofile.R
\name{tmbprofile}
\alias{tmbprofile}
\title{Adaptive likelihood profiling.}
\usage{
tmbprofile(obj, name, lincomb, h = 1e-04, ytol = 2, ystep = 0.1,
  maxit = ceiling(5 * ytol/ystep), parm.range = c(-Inf, Inf),
  slice = FALSE, trace = TRUE, ...)
}
\arguments{
\item{obj}{Object from \code{MakeADFun} that has been optimized.}

\item{name}{Name or index of a parameter to profile.}

\item{lincomb}{Optional linear combination of parameters to
profile. By default a unit vector corresponding to \code{name}.}

\item{h}{Initial adaptive stepsize on parameter axis.}

\item{ytol}{Adjusts the range of the likelihood values.}

\item{ystep}{Adjusts the resolution of the likelihood profile.}

\item{maxit}{Max number of iterations for adaptive algorithm.}

\item{parm.range}{Valid parameter range.}

\item{slice}{Do slicing rather than profiling?}

\item{trace}{Trace progress?}

\item{...}{Unused}
}
\value{
data.frame with parameter and function values.
}
\description{
Calculate 1D likelihood profiles wrt. single parameters or more
generally, wrt. arbitrary linear combinations of parameters
(e.g. contrasts).
}
\details{
Given a linear combination \deqn{ t = \sum_{i=1}^n v_i \theta_i } of
the parameter vector \eqn{\theta}, this function calculates the
likelihood profile of \eqn{t}. By default \eqn{v} is a unit vector
determined from \code{name}. Alternatively the linear combination
may be given directly (\code{lincomb}).
}
\examples{
\dontrun{
runExample("simple",thisR=TRUE)
## Parameter names for this model:
## beta   beta   logsdu   logsd0

## Profile wrt. sigma0:
prof <- tmbprofile(obj,"logsd0")
plot(prof)
confint(prof)

## Profile the difference between the beta parameters (name is optional):
prof2 <- tmbprofile(obj,name="beta1 - beta2",lincomb = c(1,-1,0,0))
plot(prof2)
confint(prof2)
}
}
\seealso{
\code{\link{plot.tmbprofile}}, \code{\link{confint.tmbprofile}}
}

