% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.functions.R
\name{obs.summ}
\alias{obs.summ}
\title{Summarizes results from TITAN's analaysis of observed data}
\usage{
obs.summ(ivzScores, taxa, srtEnv, minSplt = minSplt, imax = imax)
}
\arguments{
\item{ivzScores}{The product of the 'getivz' function.  A data
matrix comprised of four submatrices including group
membership, z scores, IndVals, and p values.}

\item{taxa}{A site by taxon matrix with counts observed at each
sampling location.}

\item{srtEnv}{A sorted version of the environmental gradient.}

\item{minSplt}{The minimum split size used to determine
partitions along the environmental gradient.  The defualt is to
use the argument from the original TITAN function call.}

\item{imax}{A logical indicating whether taxon-specific change
points should be determined using IndVal maxima or z-score
maxima (as in TITAN v1.0).}
}
\value{
The function output consists of a list of three objects:
  \itemize{ \item{obs1 }{a logical indicating decreasing taxa}
  \item{obs2 }{a logical indicating increasing taxa} \item{sppmax
  }{a partially completed summary output table for all taxa} }
}
\description{
This function populates the first seven columns of the 'sppmax'
output table with results summarized for each taxon from the
output of 'getivz'.
}
\details{
The items summarized for each taxon include (1) the env value at
the IndVal maximum, (2) the env value at the z-score maximum, (3)
the taxon's occurrence frequency, (4) group membership (decreaser
or increaser), (5) the observed IndVal score, (6) the probability
that the taxon's IndVal score could be generated by random
chance, (7) the z score. As the values 3-7 are computed for every
taxon at each candidate change point, values for the table are
determined by the maximum (IndVal or z score) indicated by the
value of 'imax'.  For further detail regarding the advantages and
disadvantages of using imax=T or imax=F, see Baker and King
(2013).
}
\author{
M. Baker and R. King
}
\references{
Baker, ME and RS King.  2010. A new method for
  detecting and interpreting biodiversity and ecological
  community thresholds.  Methods in Ecology and Evolution 1(1):
  25:37.

Baker ME and RS King. 2013. Of TITAN and straw men:
  an appeal for greater understanding of community data.
  Freshwater Science 32(2):489-506.
}
\seealso{
\code{\link{getivz}}, \code{\link{titan}}
}
\keyword{TITAN}

