% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollDbn.R
\name{rollDbn}
\alias{rollDbn}
\title{Convert a given unrolled Dynamic Bayesian Network (DBN) into a rolled DBN using different rolling methods

Rolls time-varying networks into a single time-invariant network.
This function is compatible with the time-varying networks learnt through
learnDbnStruct3dParDeg1.R::learnDbnStructMo1Layer3dParDeg1().}
\usage{
rollDbn(num.nodes, node.names, num.timepts, unrolled.DBN.adj.matrix,
  roll.method, allow.self.loop)
}
\arguments{
\item{num.nodes}{Number of the desired nodes in the rolled DBN}

\item{node.names}{Names of the desired nodes in the rolled DBN}

\item{num.timepts}{Number of time points in the unrolled DBN}

\item{unrolled.DBN.adj.matrix}{Given unrolled DBN adjacency matrix. It is a 2D matrix of dimension ((num.nodes X num.timepts) X (num.nodes X num.timepts)).}

\item{roll.method}{Which rolling method to use from {'any', 'all', or some real number in (0, 1), like - 0.5}.}

\item{allow.self.loop}{Boolean to decide whether to allow self loop or not in the rolled DBN}
}
\value{
rolled.DBN.adj.matrix Return the rolled DBN adjacency matrix. It is a 2D matrix of dimension (num.nodes * num.nodes).
}
\description{
Convert a given unrolled Dynamic Bayesian Network (DBN) into a rolled DBN using different rolling methods

Rolls time-varying networks into a single time-invariant network.
This function is compatible with the time-varying networks learnt through
learnDbnStruct3dParDeg1.R::learnDbnStructMo1Layer3dParDeg1().
}
