% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretizeData.R
\name{discretizeData.5L.wt}
\alias{discretizeData.5L.wt}
\title{Discretizes input data into five levels.}
\usage{
discretizeData.5L.wt(input.data, input.wt.data.filename, num.discr.levels)
}
\arguments{
\item{input.data}{the data that is given as the input, data frame to be discretized}

\item{input.wt.data.filename}{path of the file containing the table}

\item{num.discr.levels}{number of discrete levels}
}
\value{
input data discretized into 5 levels
}
\description{
Discretizes input data into the following five levels:
Let, expression value of gene i in a particular sample is x_i and
wild type expression value of i is wt(i).
Level 1: x_i = 0. Gene i is knocked out.
Level 2: 0 < x_i < wt(i). Gene i is down regulated but not knocked out.
Level 3: x_i = wt(i). Expression of gene i is at a steady-state.
Level 4: wt(i) < x_i < 1. Gene i is up regulated but not maximally activated.
Level 5: x_i = 1. Gene i is maximally activated.
}
