% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretizeData.R
\name{discretizeData.3L.wt}
\alias{discretizeData.3L.wt}
\title{Discretizes input data into three levels, given a tolerance.}
\usage{
discretizeData.3L.wt(input.data, input.wt.data.filename, tolerance,
  num.discr.levels)
}
\arguments{
\item{input.data}{the data that is given as the input, data frame to be discretized}

\item{input.wt.data.filename}{path of the file containing the table}

\item{tolerance}{the tolerance}

\item{num.discr.levels}{number of discrete levels}
}
\value{
input data discretized into 3 levels
}
\description{
Discretizes input data into three levels, given a tolerance.
Let, expression value of gene i in a particular sample is x_i and
wild type expression value of i is wt(i).
Level 1: 0 =< x_i < (wt(i) - tolerance). Gene i is down regulated or knocked out.
Level 2: (wt(i) - tolerance) =< x_i =< (wt(i) + tolerance). Expression of gene i is at a steady-state.
Level 3: (wt(i) + tolerance) < x_i =< 1. Gene i is up regulated.
}
