% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsymm.R
\name{rsymm_norm}
\alias{rsymm_norm}
\alias{rsymm}
\title{Simulate Symmetric Matrices with Multivariate Normal Elements}
\usage{
rsymm_norm(n, mean, sigma = diag(length(vech(mean))))

rsymm(n, mean, sigma = diag(length(vech(mean))))
}
\arguments{
\item{n}{Number of matrices to generate}

\item{mean}{A symmetric matrix specifying the mean of the distribution.}

\item{sigma}{A covariance matrix for the vectorised lower triangular elements (arranged by \code{\link[=vech]{vech()}}) of the symmetric matrix.
It is passed to \code{\link[mvtnorm:Mvnorm]{mvtnorm::rmvnorm()}} without any transformation.}
}
\value{
A set of flattened symmetric matrices as a \code{TFORGE_fsm} object. See \code{\link[=as_fsm]{as_fsm()}}.
}
\description{
Simulate symmetric matrices with elements from a multivariate Normal distribution.
}
\details{
The mean matrix is vectorised using the \code{\link[=vech]{vech()}} function
and then used as the mean vector in the \code{\link[mvtnorm:Mvnorm]{mvtnorm::rmvnorm()}} function. The covariance matrix \code{sigma} is passed unchanged to \code{\link[mvtnorm:Mvnorm]{mvtnorm::rmvnorm()}}.
Symmetric matrices can be obtained by applying \code{\link[=inv_vech]{inv_vech()}} to each simulated vector.
}
\examples{
rsymm_norm(100, diag(c(3,2,1)))
}
