% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOPC_TFM.R
\name{SOPC_TFM}
\alias{SOPC_TFM}
\title{Sparse Online Principal Component Analysis}
\usage{
SOPC_TFM(data, m, p, gamma, eta, A, D)
}
\arguments{
\item{data}{The data used in the SOPC analysis.}

\item{m}{the number of common factors}

\item{p}{the number of variables}

\item{gamma}{Tuning parameter for the sparseness of the loadings matrix.}

\item{eta}{Tuning parameter for the sparseness of the uniquenesses matrix.}

\item{A}{The true A matrix.}

\item{D}{The true D matrix.}
}
\value{
A list of metrics including:
\item{Aso}{Estimated factor loadings matrix obtained from the SOPC analysis.}
\item{Dso}{Estimated uniquenesses vector obtained from the SOPC analysis.}
\item{MSEA}{Mean squared error of the estimated factor loadings (Aso) compared to the true loadings (A).}
\item{MSED}{Mean squared error of the estimated uniquenesses (Dso) compared to the true uniquenesses (D).}
\item{LSA}{Loss metric for the estimated factor loadings (Aso), indicating the relative error compared to the true loadings (A).}
\item{LSD}{Loss metric for the estimated uniquenesses (Dso), indicating the relative error compared to the true uniquenesses (D).}
\item{tauA}{Proportion of zero factor loadings in the estimated loadings matrix (Aso), indicating the sparsity of the loadings.}
}
\description{
This function calculates various metrics for the Sparse Online Principal Component Analysis (SOPC) method. It estimates the factor loadings and uniquenesses while calculating mean squared errors and loss metrics for comparison with true values. Additionally, it computes the proportion of zero factor loadings in the estimated loadings matrix.
}
\examples{
\dontrun{
library(MASS)
library(relliptical)
library(SOPC)
SOPC_MSEA <- c()
SOPC_MSED <- c()
SOPC_LSA <- c()
SOPC_LSD <- c()
SOPC_TAUA <- c()
result <- SOPC_TFM(data, m = m, A = A, D = D, p = p)
print(result)}
}
