% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_distances.R
\name{extract_distances}
\alias{extract_distances}
\title{Compute the distance between pairs of locations}
\usage{
extract_distances(
  coords,
  method = "Haversine",
  id = NULL,
  show_progress = FALSE
)
}
\arguments{
\item{coords}{A two-column \code{matrix} or \code{data.frame} where each row represents
the coordinates of a location (see Details).}

\item{method}{A \code{character} string indicating which method to choose to
compute the distances (see Details). Available options are \code{"Haversine"} or
\code{"Euclidean"}.}

\item{id}{A vector with length equal to the number of locations, used as
row names and column names for the output distance matrix (optional, \code{NULL}
by default).}

\item{show_progress}{A boolean indicating whether a progress bar should be
displayed.}
}
\value{
A square matrix representing the distance (in kilometers) between locations.
}
\description{
This function computes the distance between pairs of locations based on
geographical coordinates.
}
\details{
\code{coords} must contain two columns: the first one for the longitude
or "X" coordinates, and the second one for the latitude or "Y" coordinates.
The \code{"Haversine"} method is used to compute great-circle distances from
longitude/latitude, while the \code{"Euclidean"} method should be used for "X/Y"
coordinates.
}
\note{
The outputs are based on the locations contained in \code{coords}, sorted
in the same order. An optional \code{id} can also be provided to be used as
names for the outputs.
}
\examples{
data(coords)

distance <- extract_distances(coords = coords, 
                              method = "Haversine",
                              id = rownames(coords))

}
\seealso{
Associated functions:
\link[=extract_spatial_information]{extract_opportunities()}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
