% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_time_series.R
\name{fmri_time_series}
\alias{fmri_time_series}
\title{visualization of the fMRI data (real, imaginary, magnitude, and phase parts) in time series}
\usage{
fmri_time_series(fmridata, voxel_location, is.4d = TRUE, ref = NULL)
}
\arguments{
\item{fmridata}{a 4d array which contains the spatial and temporal record of fMRI result or a single complex valued vector}

\item{voxel_location}{a 3d array indicating the spatial location of the brain. If is.4d is false, set the voxel_location as NULL.}

\item{is.4d}{The default is TRUE. If change to false, input a vector instead of a 4d array.}

\item{ref}{The default is NULL. User can input an outside extra reference \code{plotly} object to include in the final result.}
}
\value{
an interactive time series graph object created by \code{plotly}
}
\description{
a visualization method, use \code{plotly} to draw the fMRI data in time series
}
\details{
The function \code{fmri_time_series} is used to create four interactive time series graphs for the real, imaginary, magnitude, and phase parts for the fMRI spacetime data.
User can choose to provide the 4d array of the fMRI spacetime image and the voxel_location or a single complex valued vector, then four interactive time series graphs will be shown. 
Besides, the reference \code{plotly} object can be added to the final result.
}
\examples{
# load sample time-series data of one voxel in the brain provided by the package
sample_voxel = sample_save[[9]]
reference_plot = sample_save[[8]]
fmri_time_series(sample_voxel, voxel_location = NULL, is.4d = FALSE, ref = reference_plot)

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
